<?php
/**
* @version $Id: manager.php 2005-12-27 09:23:43Z Ryan Demmer $
* @package JCE
* @copyright Copyright (C) 2005 Ryan Demmer. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* JCE is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/
defined( '_VALID_MOS' ) or die( 'Restricted Access.' );

$mm_version = "1.0.2";

global $mosConfig_absolute_path, $mosConfig_live_site, $database, $my;

$tiny_path = $mosConfig_absolute_path."/mambots/editors/jce/jscripts/tiny_mce";
$tiny_url = $mosConfig_live_site."/mambots/editors/jce/jscripts/tiny_mce";
$mm_path = $tiny_path."/plugins/mediamanager";
$mm_url = $tiny_url."/plugins/mediamanager";
$lib_url = $tiny_url."/libraries";
$lib_path = $tiny_path."/libraries";

require_once( $tiny_path.'/auth_jce.php' );
$mmAuth = new authJCE();

//Setup languages
$database->setQuery( "SELECT lang FROM #__jce_langs WHERE published= '1'" );
$lang = $database->loadResult();

include_once ( $lib_path."/langs/$lang.php" );
include_once ( $mm_path."/langs/$lang.php" );

//Check for access rights
require_once( $mosConfig_absolute_path."/administrator/components/com_jce/plugins/plugins.class.php" );

// load Image Manager info
$query = "SELECT id"
. "\n FROM #__jce_plugins"
. "\n WHERE plugin = 'mediamanager' LIMIT 1"
;
$database->setQuery( $query );
$id = $database->loadResult();
$plugin = new jcePlugins( $database );
$plugin->load( $id );
$params = new mosParameters( $plugin->params );

//Start Authorisation check
$upload_auth        = $mmAuth->authCheck( $params->get( 'upload', '18' ) );
$folder_delete_auth = $mmAuth->authCheck( $params->get( 'folder_del', '18' ) );
$folder_rename_auth = $mmAuth->authCheck( $params->get( 'folder_ren', '18' ) );
$new_folder_auth    = $mmAuth->authCheck( $params->get( 'folder_new', '18' ) );
$file_delete_auth   = $mmAuth->authCheck( $params->get( 'file_del', '18' ) );
$file_rename_auth   = $mmAuth->authCheck( $params->get( 'file_ren', '18' ) );
$file_move_auth     = $mmAuth->authCheck( $params->get( 'file_move', '18' ) );
//End Authorisation

//Defaults
$mm_def_vspace = $params->get( 'vspace', '5' );
$mm_def_hspace = $params->get( 'hspace', '5' );
$mm_def_align = $params->get( 'align', 'left' );

include_once ( $lib_path."/classes/jce.class.php" );
require_once ( $mm_path."/classes/manager.class.php" );

//Help file check
$help_lang = ( JFile::exists( $mm_path."/docs/".$lang ) ) ? $lang : 'en';

$base_dir = $params->get( 'dir', '/images/stories' );
$base_url = $params->get( 'url', '/images/stories' );

if( $params->get( 'create_folder', '1' ) == '1' ){
  $folder = JPath::makePath( $mosConfig_absolute_path, $base_dir );
  if( !JFolder::exists( $folder ) ){
    @JFolder::createFolder( $folder );
  }
}

$dir_type = $params->get( 'dir_type', 'level' );
$user_dir = $params->get( 'user_dir', '0' );
$user_dir_level = $params->get( 'user_dir_level', '18' );
$usertype = $my->usertype;
$username = $my->username;

if( $user_dir && $mmAuth->id < $user_dir_level ){
    $base_dir = JCEUtils::userDir( $base_dir, $dir_type, $usertype, $username );
    $base_url = $base_dir;
}

$manager = new MediaManager( $base_dir, $base_url );
?>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<title><?php echo $mmlang['desc'];?></title>
	<script language="javascript" type="text/javascript" src="<?php echo $tiny_url;?>/tiny_mce_popup.js"></script>
	<script language="javascript" type="text/javascript" src="<?php echo $tiny_url;?>/utils/mctabs.js"></script>
	<script language="javascript" type="text/javascript" src="<?php echo $tiny_url;?>/utils/form_utils.js"></script>
	<script type="text/javascript" src="<?php echo $lib_url;?>/jscripts/common.js"></script>
	<script language="javascript" type="text/javascript" src="<?php echo $mm_url;?>/jscripts/manager.js"></script>
	<link href="<?php echo $lib_url;?>/css/common.css" rel="stylesheet" type="text/css" />
	<link href="<?php echo $mm_url;?>/css/manager.css" rel="stylesheet" type="text/css" />
	<script type="text/javascript">
        var base_url = "<?php echo $manager->getBaseURL();?>";
        var hostUrl = "<?php echo $mosConfig_live_site; ?>";
        var pluginurl = "<?php echo $mm_url;?>";
        var help_lang = "<?php echo $help_lang; ?>";
        var common_path = "<?php echo $lib_url;?>";
        var mm_url = "<?php echo $mm_url;?>";
        var lib_url = "<?php echo $lib_url;?>";
        var pasteAction = '';
        var source_dir = '';
        var def_vspace = "<?php echo $mm_def_vspace;?>";
        var def_hspace = "<?php echo $mm_def_hspace;?>";
        var def_align = "<?php echo $mm_def_align;?>";
        var lang = new Array();
            lang['rename_alert'] = "<?php echo $cmnlang['ren_warning'];?>";
            lang['delete_file_alert'] = "<?php echo $cmnlang['delete_file_alert'];?>";
            lang['delete_folder_alert'] = "<?php echo $cmnlang['delete_folder_alert'];?>";
	</script>
</head>
<body id="mediamanager" onload="init();" style="display: none">
    <form action="index2.php?option=com_jce&no_html=1&task=plugin&plugin=mediamanager&file=files.php" name="uploadForm" id="uploadForm" method="POST" enctype="multipart/form-data">
    <input type="hidden" name="viewMode" id="viewMode" />
    <input type="hidden" name="imgList" id="imgList" />
    <input type="hidden" name="dirList" id="dirList" />
    <input type="hidden" name="clipboard" id="clipboard" />
    <input type="hidden" name="file_ext" id="file_ext" />
    <!//--Upload Dialog-->
  	<div id="uploaddlg" class="hide">
	    <fieldset>
	    <legend><?php echo $cmnlang['upload'];?></legend>
	    <table>
		    <tr>
		    	<td colspan="4"><input type="file" name="upload" id="upload" size="50" value="" /></td>
		    </tr>
		    <tr>
		    	<td colspan="2"><input type="checkbox" id="overwrite" name="overwrite" style="vertical-align:middle;" value="false" onclick="checkUpload(this.id, 'unique');"/><label id="overwritelabel" for="overwrite"><?php echo $cmnlang['overwrite'];?></label></td>
                <td colspan="2"><input type="checkbox" id="unique" name="unique" style="vertical-align:middle;" value="false" onclick="checkUpload(this.id, 'overwrite');"/><label id="uniquelabel" for="unique"><?php echo $cmnlang['unique'];?></label></td>
            </tr>
		    <tr>
		    	<td><input type="submit" name="submit" style="cursor:pointer;" value="<?php echo $cmnlang['upload'] ?>" onclick="doUpload();" /></td>
		    	<td colspan="2">&nbsp;</td>
		    	<td align="right"><input type="button" style="cursor:pointer;" name="cancel" value="<?php echo $cmnlang['cancel'] ?>" onclick="hide(document,'uploaddlg');" /></td>
		    </tr>
	    </table>
	    </fieldset>
  	</div>
  	<!//--End Upload Dialog-->
  	<!//--New Folder Dialog-->
  	<div id="folderdlg" class="hide">
		<fieldset>
	    <legend><?php echo $cmnlang['new_dir'];?></legend>
	    <table>
		    <tr>
				<td colspan="2"><input type="text" name="folder" id="folder" size="40" /></td>
		    </tr>
		    <tr>
		    	<td><input type="button" name="createFolder" value="<?php echo $cmnlang['ok'] ?>" onclick="newFolder();" /></td>
		    	<td align="right"><input type="button" name="cancelFolder" value="<?php echo $cmnlang['cancel'] ?>" onclick="showDialog('folderdlg');" /></td>
		    </tr>
	    </table>
	    </fieldset>
  	</div>
  	<!//--End New Folder Dialog-->
  	<!//--Rename File Dialog-->
  	<div id="renfiledlg" class="hide">
	    <fieldset>
	    <legend><?php echo $cmnlang['ren'];?></legend>
	    <table>
		    <tr>
		    	<td colspan="2"><input type="text" name="newfilename" id="newfilename" size="40" />
		    	<input type="hidden" name="oldfilename" id="oldfilename" /></td>
		    </tr>
		    <tr>
		    	<td><input type="button" name="renameFile" value="<?php echo $cmnlang['ok'] ?>" onclick="renFile();" /></td>
		    	<td align="right"><input type="button" name="cancelFolder" value="<?php echo $cmnlang['cancel'] ?>" onclick="hide(document, 'renfiledlg');" /></td>
		    </tr>
	    </table>
	    </fieldset>
  	</div>
  	<!//--End Rename File Dialog-->
  	<!//--Rename Folder Dialog-->
  	<div id="rendirdlg" class="hide">
	    <fieldset>
	    <legend><?php echo $cmnlang['ren'];?></legend>
	    <table>
		    <tr>
		    	<td colspan="2"><input type="text" name="newdirname" id="newdirname" size="40" />
		    	<input type="hidden" name="dirpath" id="dirpath" />
		    	</td>
		    </tr>
		    <tr>
		    	<td><input type="button" name="renameDir" value="<?php echo $cmnlang['ok'] ?>" onclick="renDir();" /></td>
		    	<td align="right"><input type="button" name="cancelFolder" value="<?php echo $cmnlang['cancel'] ?>" onclick="hide(document, 'rendirdlg');" /></td>
		    </tr>
	    </table>
	    </fieldset>
  	</div>
  	<!//--End Rename Folder Dialog-->
	<div class="tabs">
		<ul>
			<li id="swf_tab" class="current"><span><a href="javascript:mcTabs.displayTab('swf_tab','swf_panel');" onmousedown="return false;"><?php echo $mmlang['flash'];?></a></span></li>
            <li id="mov_tab"><span><a href="javascript:mcTabs.displayTab('mov_tab','mov_panel');" onmousedown="return false;"><?php echo $mmlang['mov'];?></a></span></li>
            <li id="wmv_tab"><span><a href="javascript:mcTabs.displayTab('wmv_tab','wmv_panel');" onmousedown="return false;"><?php echo $mmlang['wmv'];?></a></span></li>
        </ul>
	</div>
	<div class="panel_wrapper">
    	<div id="swf_panel" class="panel current" style="height:80px;">
    		<fieldset>
    		<table class="properties" border="0">
				<tr>
                    <td rowspan="3" style="border:1px solid #DDD; text-align:center; width:36px;"><img src="<?php echo $mm_url;?>/images/swf_large.png" width="32" height="32" alt="Flash" title="Flash" border="0" /></td>
                    <td align="left" nowrap="nowrap"><label for="wmode"><?php echo $mmlang['swf_wmode'];?></label></td>
                    <td><select size="1" id="wmode"  title="wmode">
                            <option value="opaque" selected="selected">Opaque</option>
                            <option value="transparent">Transparent</option>
                            <option value="window">Window</option>
                    </select></td>
                    <td align="left"><label for="quality"><?php echo $mmlang['swf_quality'];?></label></td>
                    <td><select size="1" id="quality"  title="Quality">
                            <option value="best" selected>Best</option>
                            <option value="high">High</option>
                            <option value="autohigh">AutoHigh</option>
                            <option value="medium">Medium</option>
                            <option value="low">Low</option>
                            <option value="autolow">AutoLow</option>
                        </select>
                    </td>
                    <td align="left"><label for="swf_menu"><?php echo $mmlang['swf_menu'];?></label></td>
                    <td><input type="checkbox" id="swf_menu"  title="swf_menu" /></td>
                </tr>
                <tr>
                    <td align="left" nowrap="nowrap"><label for="script"><?php echo $mmlang['swf_script'];?></label></td>
                    <td><select name="script" id="script">
                            <option value="sameDomain" default>Same Domain</option>
                            <option value="always">Always</option>
                            <option value="never">Never</option>
                        </select>
                    </td>
                    <td align="left" nowrap="nowrap"><label for="scale"><?php echo $mmlang['swf_scale'];?></label></td>
                    <td><select size="1" id="scale"  title="scale">
                            <option value="" selected>Default</option>
                            <option value="noborder">No Border</option>
            				<option value="exactfit">Exact Fit</option>
            				<option value="noscale">No Scale</option>
                        </select>
                    </td>
                    <td align="left" nowrap="nowrap"><label for="swf_autoplay"><?php echo $mmlang['autoplay'];?></label></td>
                    <td><input type="checkbox" id="swf_autoplay" name="swf_autoplay" checked="checked" /></td>
                </tr>
                <tr>
                    <td align="left" nowrap="nowrap"><label for="swf_bgcolour" style="vertical-align:middle;"><?php echo $mmlang['bgcolour'];?></label>
                    <td><?php echo JCEHTML::colourPicker( 'swf_bgcolour_block', 'swf_bgcolour', '', '' );?></td>
                    <td align="left" nowrap="nowrap"><label for="swf_loop"><?php echo $mmlang['swf_loop'];?></label></td>
                    <td><input type="checkbox" name="swf_loop" id="swf_loop" checked="checked"/></td>
                </tr>
			</table>
			</fieldset>
    	</div>
    	<div id="mov_panel" class="panel" style="height:80px;">
    		<fieldset>
    		<table class="properties">
				<tr>
                    <td rowspan="3" style="border:1px solid #DDD; text-align:center; width:36px;"><img src="<?php echo $mm_url;?>/images/mov_large.png" width="32" height="32" alt="Quicktime" title="Quicktime" border="0" /></td>
                    <td align="left" style="width:80px;"><label for="mov_controller"><?php echo $mmlang['mov_contoller'];?></label></td>
                    <td>
                        <input type="checkbox" id="mov_controller"  title="mov_controller" />
                    </td>
                </tr>
                <tr>
                    <td align="left" nowrap="nowrap" style="width:80px;"><label for="mov_autoplay"><?php echo $mmlang['autoplay'];?></label></td>
                    <td><input type="checkbox" id="mov_autoplay" name="mov_autoplay" checked="checked" /></td>
                </tr>
                <tr>
                    <td align="left" nowrap="nowrap" colspan="2"><label for="mov_bgcolour" style="vertical-align:middle;"><?php echo $mmlang['bgcolour'];?></label></td>
                    <td><?php echo JCEHTML::colourPicker( 'mov_bgcolour_block', 'mov_bgcolour', '', '' );?></td>
                </tr>
            </table>
			</fieldset>
    	</div>
    	<div id="wmv_panel" class="panel" style="height:80px;">
    		<fieldset>
    		<table class="properties" border="0">
                <tr>
                    <td rowspan="3" style="border:1px solid #DDD; text-align:center; width:36px;"><img src="<?php echo $mm_url;?>/images/wmv_large.png" width="32" height="32" alt="Media Player" title="Media Player" border="0" /></td>
                    <td align="left" style="width:100px;"><label for="wmv_showcontrols"><?php echo $mmlang['show_controls'];?></label></td>
                    <td><input type="checkbox" id="wmv_showcontrols"  title="wmv_showcontrols" /></td>
                </tr>
                <tr>
                    <td align="left" nowrap="nowrap" style="width:100px;"><label for="wmv_autostart"><?php echo $mmlang['auto_start'];?></label></td>
                    <td><input type="checkbox" id="wmv_autostart" name="wmv_autostart" checked="checked" /></td>
                </tr>
                <tr>
                    <td align="left" nowrap="nowrap" style="width:100px;"><label for="wmv_status"><?php echo $mmlang['status_bar'];?></label></td>
                    <td><input type="checkbox" id="wmv_status" name="wmv_status" /></td>
                </tr>
			</table>
			</fieldset>
    	</div>
	</div>
	<fieldset>
	<legend><?php echo $mmlang['properties'];?></legend>
    <table class="properties" border="0">
        <tr>
            <td class="column1" style="width:100px;"><label id="srclabel" for="src"><?php echo $cmnlang['url'];?></label></td>
            <td colspan="5">
    	    <table border="0" cellspacing="0" cellpadding="0">
    	       <tr>
    	           <td><input name="src" class="large_input" type="text" id="src" value="" /></td>
    	       </tr>
        	</table>
    	   </td>
       	</tr>
        <tr>
			<td class="column1" style="width:100px;"><label id="widthlabel" for="width"><?php echo $cmnlang['dimensions'];?></label></td>
			<td nowrap="nowrap" colspan="3">
    			<input name="width" type="text" id="width" value="" size="5" maxlength="5" onchange="changeHeight();" /> x
    			<input name="height" type="text" id="height" value="" size="5" maxlength="5" onchange="changeWidth();" /> px
                <input id="constrain" type="checkbox" name="constrain" class="checkbox" checked="checked" />
                <label id="constrainlabel" for="constrain"><?php echo $cmnlang['constrain'];?></label>
                <input type="hidden" id="orig_width" name="orig_w" value="" />
                <input type="hidden" id="orig_height" name="orig_h" value="" />
            </td>
	   </tr>
	   <tr>
        	<td class="column1" style="width:100px;"><label id="vspacelabel" for="vspace"><?php echo $cmnlang['vspace'];?></label></td>
        	<td nowrap="nowrap" colspan="3"><input name="vspace" type="text" id="vspace" value="" size="3" maxlength="3" onchange="changeAppearance();updateStyle();" />
            <label id="hspacelabel" for="hspace"><?php echo $cmnlang['hspace'];?></label>
        	<input name="hspace" type="text" id="hspace" value="" size="3" maxlength="3" onchange="changeAppearance();updateStyle();" /></td>
       </tr>
       <tr>
	       <td td class="column1"><label id="alignlistlabel" for="align"><?php echo $cmnlang['align'];?></label></td>
	       <td nowrap="nowrap" colspan="3"><?php echo JCEHTML::Align('');?></td>
       </tr>
    </table>
	</fieldset>
	<fieldset>
	<legend><?php echo $cmnlang['browse'];?></legend>
    <div id="msgIcon">
        <img id="imgMsgContainer" src="<?php echo $lib_url;?>/images/spacer.gif" width="16" height="16" border="0" alt="Message" title="Message" />
    </div>
    <div id="msgDiv">
        <span id="msgContainer" style="vertical-align:top;"></span>
    </div>
    <div id="dirListBlock">
        <label for="dirlistcontainer" style="vertical-align:middle;"><?php echo $cmnlang['dir'];?></label>&nbsp;<div id="dirlistcontainer" style="vertical-align:middle;"></div>
    </div>
    <div id="dirImg" style="display: inline;"><a href="javascript:void(0)" onclick="javascript: goUpDir();" title="<?php echo $cmnlang['dir_up'];?>" class="toolbar"><img src="<?php echo $lib_url;?>/images/dir_up.gif" width="20" height="20" border="0" alt="<?php echo $cmnlang['dir_up'];?>" /></a></div>

    <?php if( $new_folder_auth ){?>
        <div id="folderImg" style="display: inline;"><a href="javascript:void(0)" class="toolbar" onclick="showDlg(document, 'folderdlg');" title="<?php echo $cmnlang['new_dir'];?>"><img src="<?php echo $lib_url;?>/images/new_folder.gif" width="20" height="20" alt="<?php echo $cmnlang['new_dir'];?>" /></a></div>
    <?php }?>

    <?php if( $upload_auth ){?>
        <div id="upImg" style="display: inline;"><a href="javascript:void(0)" onclick="showDlg(document, 'uploaddlg');" class="toolbar"><img src="<?php echo $lib_url;?>/images/upload.gif" border="0" alt="<?php echo $cmnlang['upload'];?>" width="20" height="20" title="<?php echo $cmnlang['upload'];?>" /></a></div>
    <?php }?>
   <div id="hlpIcon" style="display: inline;"><a href="javascript:void(0)" onclick="javascript: openHelp();" class="toolbar"><img src="<?php echo $lib_url;?>/images/help.gif" border="0" alt="<?php echo $cmnlang['help'];?>" width="20" height="20" title="<?php echo $cmnlang['help'];?>" /></a></div>

    <!--//File Frame-->
    <div id="fileContainer"></div>
    <!--//File Frame-->
    <!--//File Info-->
    <div id="infoBlock">
        <div id="infoTitle">
            <?php echo $cmnlang['details'];?>
        </div>
        <div id="fileDetails">
            <span id="info1" style="font-weight:bold;" class="hide"></span>
                <input type="hidden" id="info1Val" value="" />
            <span id="info2" class="hide"></span>
                <input type="hidden" id="info2Val" value="" />
            <span id="info3" class="hide"></span>
                <input type="hidden" id="info3Val" value="" />
            <span id="info4" class="hide"></span>
                <input type="hidden" id="info4Val" value="" />
            <span id="info5" class="hide"></span>
                <input type="hidden" id="info5Val" value="" />
            <span id="info6" class="hide"></span>
                <input type="hidden" id="info6Val" value="" />
        </div>
    </div>
    <!--//File Info-->
    <!--//Tools-->
    <div id="toolsList">
        <!--//Rename-->
        <?php if( $file_rename_auth ) {?>
       	    <div class="hide" id="renImg"><a href="javascript:void(0)" id="renLink" class="tools" onclick="fileAction('rename', 'file');"><img src="<?php echo $lib_url;?>/images/rename.gif" alt="<?php echo $cmnlang['ren'];?>" title="<?php echo $cmnlang['ren'];?>" width="20" height="20" id="renIcon" /></a></div>
        <?php }else{?>
       	    <div id="renImg" class="hide"></div>
        <?php }?>

        <!--//Delete-->
        <?php if( $file_delete_auth ) {?>
       	    <div id="delImg" class="hide"><a href="javascript:void(0)" id="delLink" title="<?php echo $cmnlang['del'] ?>" onclick="fileAction('delete', 'file');" class="tools"><img src="<?php echo $lib_url;?>/images/delete.gif" id="delIcon" height="20" width="20" border="0" alt="<?php echo $cmnlang['del'] ?>" /></a> </div>
        <?php }else{?>
       	    <div id="delImg" class="hide" ></div>
        <?php }?>

       	<?php if( $file_move_auth ) {?>
        <!--//Copy-->
        <div id="copyImg" class="hide"><a href="javascript:void(0)" id="copyLink" title="<?php echo $cmnlang['copy'] ?>" onclick="copyFile();" class="tools"><img src="<?php echo $tiny_url;?>/themes/advanced/images/copy.gif" id="copyIcon" height="20" width="20" border="0" alt="<?php echo $cmnlang['copy'];?>" /></a> </div>

        <!--//Cut-->
        <div id="cutImg" class="hide"><a href="javascript:void(0)" id="cutLink" title="<?php echo $cmnlang['cut'] ?>" onclick="cutFile();" class="tools"><img src="<?php echo $tiny_url;?>/themes/advanced/images/cut.gif" id="cutIcon" height="20" width="20" border="0" alt="<?php echo $cmnlang['cut'];?>" /></a> </div>

        <!--//Paste-->
        <div id="pasteImg" class="hide"><a href="javascript:void(0)" id="pasteLink" title="<?php echo $cmnlang['paste'] ?>" onclick="pasteFile();" class="tools"><img src="<?php echo $tiny_url;?>/themes/advanced/images/paste.gif" id="pasteIcon" height="20" width="20" border="0" alt="<?php echo $cmnlang['paste'];?>" /></a> </div>
		<?php }else{?>
       	    <div id="copyImg" class="hide"></div>
       	    <div id="cutImg" class="hide"></div>
       	    <div id="pasteImg" class="hide"></div>
        <?php }?>
        
        <!--//View-->
        <div id="viewImg" class="hide"><a href="javascript:void(0)" id="viewLink" title="<?php echo $cmnlang['view'] ?>" onclick="viewFile();" class="tools"><img src="<?php echo $lib_url;?>/images/view.gif" id="viewIcon" height="20" width="20" border="0" alt="<?php echo $cmnlang['view'];?>" /></a> </div>

        <!--//Folder Delete-->
        <?php if( $folder_delete_auth ) {?>
       	    <div id="delDir" class="hide"> <a href="javascript:void(0)" id="delDirLink" title="<?php echo $cmnlang['del'] ?>" onclick="fileAction('delete', 'folder');" class="tools"><img src="<?php echo $lib_url;?>/images/delete.gif" id="delDirIcon" height="20" width="20" border="0" alt="<?php echo $cmnlang['del'];?>" /></a> </div>
        <?php }else{?>
       	    <div id="delDir" class="hide"></div>
        <?php }?>

        <!--//Folder Rename-->
        <?php if( $folder_rename_auth ) {?>
       	    <div id="renDir" class="hide"> <a href="javascript:void(0)" id="renDirLink" title="<?php echo $cmnlang['ren'] ?>" onclick="fileAction('rename', 'folder');" class="tools"><img src="<?php echo $lib_url;?>/images/rename.gif" id="renDirIcon" height="20" width="20" border="0" alt="<?php echo $cmnlang['ren'];?>" /></a> </div>
        <?php }else{?>
       	    <div id="renDir" class="hide"></div>
        <?php }?>
    </div>
    <!--//Tools-->
    </fieldset>
	<div class="mceActionPanel">
		<div style="float: right">
    		<input type="button" class="button "id="refresh" name="refresh" value="<?php echo $cmnlang['refresh'];?>" onclick="refreshAction();" />
			<input type="button" id="insert" name="insert" value="{$lang_insert}" onclick="insertAction();" />
			<input type="button" id="cancel" name="cancel" value="<?php echo $cmnlang['cancel'];?>" onclick="cancelAction();" />
		</div>
	</div>
    </form>
</body> 
</html> 
