function preinit() {
	// Initialize
	tinyMCE.setWindowArg('mce_windowresize', false);
	tinyMCE.setWindowArg('mce_replacevariables', false);
}
function init() {
	tinyMCEPopup.resizeToInnerSize();

    var formObj = document.forms[0];

    var uploadForm = document.getElementById('uploadForm');
    if(uploadForm) uploadForm.target = 'mediaManager';

	var title     = tinyMCE.getWindowArg('mm_title');
	var mmwidth  = tinyMCE.getWindowArg('mm_width');
	var mmheight = tinyMCE.getWindowArg('mm_height');
	var mmvspace  = tinyMCE.getWindowArg('mm_vspace');
	var mmhspace  = tinyMCE.getWindowArg('mm_hspace');
	var mmalign   = tinyMCE.getWindowArg('mm_align');

	var path = '';
    var file = '';
    
	str = title.split('|');

    formObj.width.value  = mmwidth;

    formObj.vspace.value = ( mmvspace != '' ) ? mmvspace : def_vspace;
    formObj.hspace.value = ( mmhspace != '' ) ? mmhspace : def_hspace;
    var align_val = ( mmalign != '' ) ? mmalign : def_align;
    
    selectByValue(formObj, 'align', align_val);
    
    var ext = getExtension(str[0]);
    formObj.file_ext.value = ext;
    switch(ext){
        case 'asf':
        case 'asx':
        case 'wmv':
        case 'avi':
        case 'mpg':
        case 'mpeg':
            mcTabs.displayTab('wmv_tab','wmv_panel');
            formObj.wmv_showcontrols.checked = (str[1] == 'true') ? true : false;
            formObj.wmv_autostart.checked = (str[2] == 'true') ? true : false;
            formObj.wmv_status.checked = (str[3] == 'true') ? true : false;
        break;
        case 'mov':
        case 'mp4':
            mcTabs.displayTab('mov_tab','mov_panel');
            formObj.mov_bgcolour.value = str[1];
            formObj.mov_bgcolour_block.style.backgroundColor = str[1];
            formObj.mov_controller.checked  = (str[2] == 'true') ? true : false;
            formObj.mov_autoplay.checked = (str[3] == 'true') ? true : false;
            if(formObj.mov_controller.checked) mmheight = parseInt(mmheight)-16;
        break;
        case 'swf':
        case 'flv':
            mcTabs.displayTab('swf_tab','swf_panel');
            selectByValue(formObj, 'quality', str[1]);
            selectByValue(formObj, 'wmode', str[6]);
            selectByValue(formObj, 'scale', str[5]);
            selectByValue(formObj, 'script', str[7]);
            formObj.swf_menu.checked  = (str[2] == 'true') ? true : false;
            formObj.swf_loop.checked = (str[8] == 'true') ? true : false;
            formObj.swf_autoplay.checked = (str[4] == 'true') ? true : false;
            formObj.swf_bgcolour.value = str[3];
            formObj.swf_bgcolour_block.style.backgroundColor = str[3];
            if(formObj.mov_controller.checked) mmheight = parseInt(mmheight)-64;
        break;
    }
    formObj.height.value = mmheight;
	formObj.src.value = str[0];
	formObj.orig_w.value = mmwidth;
	formObj.orig_h.value = mmheight;
	
	var dir = str[0].replace( base_url, '', 'g' );
    var path_parts = dir.split('/');
    path_parts.pop();
    path = path_parts.join('/');
    file = dir.replace( path, '', 'g' );

    window.setTimeout('createFileIFrame("' + path + '","' + file + '");', 10);
	formObj.insert.value = tinyMCE.getLang('lang_' + tinyMCE.getWindowArg('action'), 'Insert', true);
}

function insertAction() {
	var formObj = document.forms[0];
	var html      = '';
	var file      = formObj.src.value;
	var width     = formObj.width.value;
	var height    = formObj.height.value;
	var ext       = formObj.file_ext.value;
	var file_class = 'mceItemFlash';
	var align = getSelectValue(formObj, 'align');
	var hspace = formObj.hspace.value;
	var vspace = formObj.vspace.value;
	var id = 'mce_media_flash';
	
	if (width == "")
		width = 100;

	if (height == "")
		height = 100;

    switch(ext){
        case 'asf':
        case 'asx':
        case 'wmv':
        case 'avi':
        case 'mpg':
        case 'mpeg':
            file_class = 'mceItemMedia';
            id = 'mce_media_wmv';
            var menu        = (formObj.wmv_showcontrols.checked)?'true' : 'false';
            if(menu) height = parseInt(height)+64;
            var autoplay    = (formObj.wmv_autostart.checked)?'true' : 'false';
            var status      = (formObj.wmv_status.checked)?'true' : 'false';
            var fileStr     = file+"|"+menu+"|"+autoplay+"|"+status;
        break;
        case 'mov':
        case 'mp4':
            file_class = 'mceItemMov';
            id = 'mce_media_mov';
            var menu        = (formObj.mov_controller.checked)?'true' : 'false';
            if(menu) height = parseInt(height)+16;
            var bgcolor     = formObj.mov_bgcolour.value;
            var autoplay    = (formObj.mov_autoplay.checked == true)?'true' : 'false';
            var fileStr     = file+"|"+bgcolor+"|"+menu+"|"+autoplay;
        break;
        case 'swf':
        case 'flv':
            file_class = 'mceItemFlash';
            id = 'mce_media_swf';
            var quality     = getSelectValue(formObj, 'quality');
            var bgcolor     = formObj.swf_bgcolour.value;
            var scale       = getSelectValue(formObj, 'scale');
            var wmode       = getSelectValue(formObj, 'wmode');
            var script      = getSelectValue(formObj, 'script');
            var menu        = (formObj.swf_menu.checked)?'true' : 'false';
            var loop        = (formObj.swf_loop.checked)?'true' : 'false';
            var autoplay    = (formObj.swf_autoplay.checked)?'true' : 'false';
            var fileStr     = file+"|"+quality+"|"+menu+"|"+bgcolor+"|"+autoplay+"|"+scale+"|"+wmode+"|"+script+"|"+loop;
        break;
    }
    
	html += ''
		+ '<img src="' + (tinyMCE.getParam("theme_href") + "/images/spacer.gif") + '" '
		+ 'width="' + width + '" height="' + height + '" align="' + align + '" hspace="' + hspace + '" vspace="' + vspace + '"'
		+ 'border="0" alt="' + file + '" title="' + fileStr + '" id="' + id + '"class="' + file_class + '" />';

	tinyMCEPopup.execCommand("mceInsertContent", true, html);
	tinyMCE.selectedInstance.repaint();

	tinyMCEPopup.close();
}
function convertURL(url, node, on_save) {
	return eval("tinyMCEPopup.windowOpener." + tinyMCE.settings['urlconverter_callback'] + "(url, node, on_save);");
}

function cancelAction()
{
    tinyMCEPopup.close();
}
function createFileIFrame(dir, file) {
    dir = ( dir != '' ) ? '&dir='+dir : '';
    file = ( file != '' ) ? '&ret_file='+file : '';

    document.getElementById('fileContainer').innerHTML = '<iframe class="fileFrame" id="mediaManager" name="mediaManager" src="index2.php?option=com_jce&no_html=1&task=plugin&plugin=mediamanager&file=files.php' + dir + file + '" frameborder="0"></iframe>';
}
function updateDir(selection)
{
    var formObj = document.forms[0];
    var newDir = getSelectValue(formObj, 'dirPath');
    if(typeof mediaManager != 'undefined')
        mediaManager.refreshDir(newDir);
}
function goUpDir()
{
    var formObj = document.forms[0];
    var currentDir = getSelectValue(formObj, 'dirPath');
    if(currentDir.length < 2)
        return false;
    var dirs = currentDir.split('%2F');
    var search = '';
    for(var i = 0; i < dirs.length-1; i++)
    {
        search += dirs[i]+'/';
    }
    search = search.substr(0, search.length-1);
    changeDir(search);
}
function changeDir(newDir)
{
    if(typeof mediaManager != 'undefined')
        mediaManager.changeDir(newDir);
}
function changeHeight() {
	var formObj = document.forms[0];

	if (!formObj.constrain.checked) {
		return;
	}

	if (formObj.width.value == "" || formObj.height.value == "")
		return;

	var temp = (formObj.width.value / formObj.orig_width.value) * formObj.orig_height.value;
	formObj.height.value = temp.toFixed(0);
}

function changeWidth() {
	var formObj = document.forms[0];

	if (!formObj.constrain.checked) {
		return;
	}

	if (formObj.width.value == "" || formObj.height.value == "")
		return;

	var temp = (formObj.height.value / formObj.orig_height.value) * formObj.orig_width.value;
	formObj.width.value = temp.toFixed(0);
}
function doUpload()
{
    var uploadForm = document.getElementById('uploadForm');
    if(uploadForm){
        showMessage(document, 'Uploading', 'load', 'msg');
        hide( document, 'uploaddlg' );
    }
}
function newFolder()
{
    var formObj = document.forms[0];
    var dir = getSelectValue(formObj, 'dirPath');
    var newfolder = document.getElementById('folderdlg');

    var folder = document.getElementById('folder').value;
    if (folder && folder != '' && typeof mediaManager != 'undefined')
        mediaManager.newFolder(dir, encodeURI(folder));
    hide( document, 'folderdlg' );
    document.getElementById('folder').value = '';
}
function openHelp() {
    var url = hostUrl+'/index2.php?option=com_jce&task=help&plugin=mediamanager&file=help.php';
    w = 600;
    h = 500;

    openWin(url, w, h, 'yes', 'yes');
}
function viewFile()
{
    var formObj = document.forms[0];
    var dir = getSelectValue(formObj, 'dirPath')
    var file = document.getElementById('imgList').value;

    var url = base_url+file;
    w = 600;
    h = 500;
    openWin(url, w, h, 'yes', 'yes');
}
function refreshAction()
{
	var selection = document.getElementById('dirPath');
    updateDir(selection);
}
function showUpload() {
    showDlg(document, 'uploaddlg');
}
function showRenameFile(file, name)
{
    if(document.getElementById('renfiledlg').className == "hide")
    {
        document.getElementById('newfilename').value = '';
        document.getElementById('oldfilename').value = '';
    }else{
        if(document.getElementById('renfiledlg').className == "show"){
            document.getElementById('newfilename').value = name;
            document.getElementById('oldfilename').value = file;
        }
    }
}
function showRenameDir(name, path)
{
    if(document.getElementById('rendirdlg').className == "hide")
    {
        document.getElementById('newdirname').value = '';
        document.getElementById('dirpath').value = '';
    }else{
        if(document.getElementById('rendirdlg').className == "show"){
            document.getElementById('newdirname').value = name;
            document.getElementById('dirpath').value = path;
        }
    }
}
function copyFile()
{
    var formObj = document.forms[0];
    var dir = getSelectValue(formObj, 'dirPath');
    var file = document.getElementById('imgList').value;
    document.getElementById('clipboard').value = file;
    show( document, 'pasteImg' );
    pasteAction = 'copy';
    source_dir = dir;
}
function cutFile()
{
    var formObj = document.forms[0];
    var dir = getSelectValue(formObj, 'dirPath');
    var file = document.getElementById('imgList').value;
    document.getElementById('clipboard').value = file;
    show( document, 'pasteImg' );
    pasteAction = 'cut';
    source_dir = dir;
}
function pasteFile()
{
    var formObj = document.forms[0];
    var dir = getSelectValue(formObj, 'dirPath');
    var file = document.getElementById('clipboard').value;
    mediaManager.moveFile(file, dir, pasteAction);
    document.getElementById('clipboard').value = '';
    hide( document, 'pasteImg' );
}
function fileAction(action, opt)
{
    var formObj = document.forms[0];
    var dir = getSelectValue(formObj, 'dirPath');
    var mode = document.getElementById('viewMode').value;
    var file = document.getElementById('imgList').value;
    var path = document.getElementById('dirList').value;
    var pasteAction = 'copy';

    switch (opt){
        case 'file' :
        switch (action){
            case 'delete' :
                if(confirmAction(lang['delete_file_alert'])) {
                    mediaManager.delFile(dir, file);
                    return true;
                }
                return false;
            break;
            case 'rename' :
                var name = document.getElementById('info1Val').value;
                showDlg(document, 'renfiledlg');
                showRenameFile(file, name);
            break;
        }
        break;
        case 'folder' :
            switch (action){
                case 'delete' :
                    if(confirmAction(lang['delete_folder_alert'])) {
                        mediaManager.delDir(dir, path);
                        return true;
                    }
                    return false;
                break;
                case 'rename' :
                    var name = document.getElementById('info1Val').value;
                    showDlg(document, 'rendirdlg');
                    showRenameDir(name, path);
                break;
            }
        break;
    }
}
function renFile()
{
    var formObj = document.forms[0];
    var dir = getSelectValue(formObj, 'dirPath');
    var file = document.getElementById('oldfilename').value;
    var name = document.getElementById('newfilename').value;

    if(confirmAction(tinyMCE.getLang('lang_mediamanager_rename_alert', '', true))) {
        mediaManager.renFile(dir, file, name);
    }else{
        return false;
    }
}
function renDir()
{
    var formObj = document.forms[0];
    var dir = getSelectValue(formObj, 'dirPath');
    var name = document.getElementById('newdirname').value;
    var relative = document.getElementById('dirpath').value;

    if(confirmAction(tinyMCE.getLang('lang_mediamanager_rename_alert', '', true))) {
        mediaManager.renDir(dir, name, relative);
    }else{
        return false;
    }
}
function confirmAction(action) {
    if(confirm(action)) {
        return true;
    }
    return false;
}
// While loading
preinit();
