//Javascript functions for the Image Manager. Used by images.php and list.php
function resetEditor()
{
    topDoc.getElementById('imgList').value = '';
    topDoc.getElementById('dirList').value = '';
    if(topDoc.getElementById('clipboard').value != '')
        iconState('off', 'paste');
}
function refreshDir(newDir)
{
    showMessage(topDoc, 'Loading', 'load', 'msg');
    location.href = "index2.php?option=com_jce&no_html=1&task=plugin&plugin=mediamanager&file=files.php&dir="+encodeURI(newDir);
}
function changeDir(newDir)
{
    showMessage(topDoc, 'Loading', 'load', 'msg');
    location.href = "index2.php?option=com_jce&no_html=1&task=plugin&plugin=mediamanager&file=files.php&dir="+encodeURI(newDir);
}
function newFolder(dir, newDir)
{
    location.href = "index2.php?option=com_jce&no_html=1&task=plugin&plugin=mediamanager&file=files.php&opt=new_folder&dir="+dir+"&newd="+newDir;
}
function delDir(dir, path)
{
    location.href = "index2.php?option=com_jce&no_html=1&task=plugin&plugin=mediamanager&file=files.php&opt=del_folder&dir="+dir+"&deld="+encodeURI(path);
}
function doUpload(dir)
{
    location.href = "index2.php?option=com_jce&no_html=1&task=plugin&plugin=mediamanager&file=files.php&dir="+dir+"&refresh=1";
}
function delFile(dir, file)
{
    location.href = "index2.php?option=com_jce&no_html=1&task=plugin&plugin=mediamanager&file=files.php&opt=del_file&dir="+encodeURI(dir)+"&delf="+encodeURI(file);
}
function moveFile(file, dir, option)
{
    switch( option ){
        case 'copy':
            location.href = "index2.php?option=com_jce&no_html=1&task=plugin&plugin=mediamanager&file=files.php&opt=copy_file&dir="+dir+"&copyf="+file+"&dest="+dir;
        break;
        case 'cut':
            location.href = "index2.php?option=com_jce&no_html=1&task=plugin&plugin=mediamanager&file=files.php&opt=move_file&dir="+dir+"&movef="+file+"&dest="+dir;
        break;
    }
}
function renFile(dir, file, name )
{
    location.href = "index2.php?option=com_jce&no_html=1&task=plugin&plugin=mediamanager&file=files.php&opt=rename_file&dir="+dir+"&renf="+file+"&newf="+name;
    hide( topDoc, 'renfiledlg' );
    topDoc.getElementById('newfilename').value = '';
    topDoc.getElementById('oldfilename').value = '';
}
function renDir(dir, name, relative)
{
    location.href = "index2.php?option=com_jce&no_html=1&task=plugin&plugin=mediamanager&file=files.php&opt=rename_folder&dir="+dir+"&rend="+relative+"&newd="+name;
    hide( topDoc, 'rendirdlg' );
    topDoc.getElementById('newdirname').value = '';
    topDoc.getElementById('dirpath').value = '';
}

function resetPreview()
{
    hide( topDoc, 'info1' );
    hide( topDoc, 'info2' );
    hide( topDoc, 'info3' );
    hide( topDoc, 'info4' );
    hide( topDoc, 'info5' );
}
function iconState(state, opt){
    switch (state){
        case 'on' :
        switch(opt){
            case 'single' :
                show( topDoc, 'delImg' );
                show( topDoc, 'copyImg' );
                show( topDoc, 'cutImg' );
                show( topDoc, 'renImg' );
            break;
            case 'multiple' :
                show( topDoc, 'delImg' );
                show( topDoc, 'copyImg' );
                show( topDoc, 'cutImg' );
                hide( topDoc, 'renImg' );
            break;
        }
        break;
        case 'off' :
                hide( topDoc, 'delImg' );
                hide( topDoc, 'copyImg' );
                hide( topDoc, 'cutImg' );
                hide( topDoc, 'renImg' );
        break;
    }
}
function selectFile(filename, title, ext, w, h)
{
    var formObj = parent.document.forms[0];
    formObj.src.value = filename;
    formObj.title.value = title;
    switch(ext){
        case 'asf':
        case 'asx':
        case 'wmv':
        case 'avi':
        case 'mpg':
        case 'mpeg':
            parent.mcTabs.displayTab('wmv_tab','wmv_panel');
        break;
        case 'mov':
        case 'mp4':
            parent.mcTabs.displayTab('mov_tab','mov_panel');
        break;
        case 'swf':
            parent.mcTabs.displayTab('swf_tab','swf_panel');
        break;
    }
    formObj.width.value = w;
    formObj.height.value = h;
    formObj.orig_width.value = w;
    formObj.orig_height.value = h;
    formObj.file_ext.value = ext;
}
function showFile(option, numfiles, relative, file, name, type, size, modified, time, w, h, play_time)
{
    type = type.toUpperCase();
    
    switch( type.toLowerCase() )
    {
        case 'asf':
        case 'asx':
        case 'wmv':
        case 'avi':
        case 'mpg':
        case 'mpeg':
            parent.mcTabs.displayTab('wmv_tab','wmv_panel');
        break;
        case 'mov':
        case 'mp4':
            parent.mcTabs.displayTab('mov_tab','mov_panel');
        break;
        case 'swf':
            parent.mcTabs.displayTab('swf_tab','swf_panel');
        break;
    }

    if(option == 'single'){
        var nameTxt =  ""+name+"";
        var extTxt = ""+type+" File";
        var sizeTxt = "Size: "+size+"";
        var dimTxt = "Dimensions: "+w+" x "+h;
        var timeTxt = "Length: "+play_time+" min:sec";
        var modTxt = "Modified: "+modified+","+time;
    }else{
        var nameTxt =  ""+numfiles+" files selected.";
        var extTxt = "";
        var sizeTxt = "";
        var dimTxt = "";
        var timeTxt = "";
        var modTxt = "";
    }
    show( topDoc, 'info1' );
    show( topDoc, 'info2' );
    show( topDoc, 'info3' );
    show( topDoc, 'info4' );
    show( topDoc, 'info5' );
    show( topDoc, 'info6' );
    
    topDoc.getElementById('info1Val').value = name;
    topDoc.getElementById('info2Val').value = type;
    topDoc.getElementById('info3Val').value = w+','+h;
    topDoc.getElementById('info4Val').value = play_time;
    topDoc.getElementById('info5Val').value = size;
    topDoc.getElementById('info6Val').value = modified+','+time;

    createInfo(topDoc, 'info1', nameTxt);
    createInfo(topDoc, 'info2', extTxt);
    createInfo(topDoc, 'info3', dimTxt);
    createInfo(topDoc, 'info4', timeTxt);
    createInfo(topDoc, 'info5', sizeTxt);
    createInfo(topDoc, 'info6', modTxt);

    hide( topDoc, 'delDir' );
    hide( topDoc, 'renDir' );
    hide( topDoc, 'viewImg' );
    if( type.toLowerCase() == 'swf' || type.toLowerCase() == 'mov')
        show( topDoc, 'viewImg' );

    topDoc.getElementById('dirList').value = '';
}
function showFolder(dirname, modified, time, files, folders)
{
    show( topDoc, 'info1' );
    show( topDoc, 'info2' );
    show( topDoc, 'info3' );

    var nameTxt =  ""+dirname+"";
    var nameType = lang['folder'];
    var numTxt = files+" " + lang['files'] + " "+folders+" " + lang['folders'] + "";

    createInfo(topDoc, 'info1', nameTxt);
    createInfo(topDoc, 'info2', nameType);
    createInfo(topDoc, 'info3', numTxt);

    removeInfo(topDoc.getElementById('info4'));
    removeInfo(topDoc.getElementById('info5'));
    removeInfo(topDoc.getElementById('info6'));

    hide( topDoc, 'viewImg' );
    show( topDoc, 'renDir' );
    show( topDoc, 'delDir' );

    topDoc.getElementById('info1Val').value = dirname;

    topDoc.getElementById('imgList').value = '';

    iconState('off','');
}
function setReturnFile(file)
{
    var elm = document.getElementById('fileList');
    var child = ( elm.childNodes );
    var formObj = parent.document.forms[0];
    for ( var i = 0; i < child.length; i++ ) {
        if( child[i].tagName == 'LI' ){
            var val = child[i].getAttribute('value');
            var arr = val.split(',');
            if( file == arr[0] ){
                sf.setItemSelected(child[i], true);
                showFile('single', i, arr[0], arr[1], arr[2], arr[3], arr[4], arr[5], arr[6], arr[7], arr[8], arr[9]);
                iconState('on', 'single');
                parent.document.getElementById("imgList").value = arr[0];
            }
        }
    }
}
