<?php

/**
 * Shortlink mambot for com_shortlink (for use with mambo 4.5.1+)
 * All rights reserved Mambo Open Source is Free Software Released under GNU/GPL
 * @by Tobias Gesellchen, www.gesellix.de
 * @Copyright (C) 2005 http://www.gesellix.de/
 * 1.0 for Mambo 4.5.1
 */

defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');

$_MAMBOTS->registerFunction('onPrepareContent', 'botShortlink');

function botShortlink($published, &$row, &$params, $page = 0) {

  global $database, $mosConfig_live_site;

  // Get parameters from Database
/*
  $query = "SELECT id FROM #__mambots WHERE element = 'shortlink' AND folder = 'content'";
  $database->setQuery($query);
  $id = $database->loadResult();
  $mambot = new mosMambot($database);
  $mambot->load($id);
  $param = &new mosParameters($mambot->params);
*/

  $content = $row->text;
  $matches = array ();

  if (preg_match_all("/{shortlink:.+?}/", $content, $matches, PREG_PATTERN_ORDER)) {

    //Get the ID of the file
    foreach ($matches as $fmatch) {
      foreach ($fmatch as $match) {
        $match = str_replace("{shortlink:", "", $match);
        $match = str_replace("}", "", $match);

        $pieces = explode(",", $match);
        
        $link   = $mosConfig_live_site."/goto.php?link=".$pieces[0];

        $name   = $link;
        if ($pieces[1]){
          $name = $pieces[1];
          $link = "$link title=\"$name\"";
        }

        if ($pieces[2] == "ext"){
          $link = "$link target=\"_blank\"";
        }

        $output = "<a href=$link>$name</a>";

        $content = preg_replace("/{shortlink:$match}/", $output, $content);
      }
    }
  }

  $row->text = $content;
  return true;
}
?>
