<?php

/**
* Badword Filter Component!
* By Pravin Hegde
* @ All rights reserved
* @ Badword Filter! component is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @ version 1.0
**/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

//global $bw_file_badwords, $bw_file_admins, $bw_file_regexps ;
global $bw_perform_filter, $bw_allow_admin, $bw_perform_regexp;
global $bw_regexp_array, $bw_admin_array, $bw_word_array;
global $mosConfig_absolute_path;

require_once( 'administrator/components/com_badwords2/settings.badwords2.php' );
require_once( 'administrator/components/com_badwords2/settings.badwords2.perm.php' );

if (!isset($bw_word_array)) {
   $bw_word_array = file($mosConfig_absolute_path."/administrator/".$bw_file_badwords);
   $bw_regexp_array = file($mosConfig_absolute_path."/administrator/".$bw_file_regexps);
   $bw_admin_array = file($mosConfig_absolute_path."/administrator/".$bw_file_admins);
}

/**
 * Primary request processor for the badword filter
 * Invoke the badword filter as Badword::filter();
 * True or false is returned.
 *
 * Or invoke as Badword::flush();
 * A moderated string is returned.
 */

class Badword {

	/**
	 * Run the badword filter on the provided text
	 * Returns a flag indicating '1' - true or '0' - false
	 * based on the badword filter setup
	 */
	function filter($text, $user) {
		global $bw_regexp_array, $bw_admin_array, $bw_word_array;
		global $bw_perform_filter, $bw_allow_admin, $bw_perform_regexp;

		// Quit to return false if configured
		// not to perform filter
		if ($bw_perform_filter == '0') {
			return 0;
		}

		// Check for allow badwords for admin users
		// as per the configuration
		if ($bw_allow_admin == '1' && Badword::isAdminUser($user) == 1) {
			return 0;
		}

		// Else perform basic badword check

		foreach ($bw_word_array as $badword) {
			// remove whitespace at beginning or end of badword
			$badword = trim($badword);

                        // select the right regular expression in case of wildcards
                        switch (TRUE) {
                        case ( $badword{0} == "*" && substr($badword, -1) == "*" ): // *badword*
                          $badword = substr($badword, 1, -1);
			  if ( preg_match("/$badword/i",$text ) ) {
                             return 1;
                          }
                        break;
                        case ( substr($badword, -1) == "*"):                        // badword*
                          $badword = substr($badword, 0, -1);
			  if ( preg_match("/(\W|^)$badword/i", $text) ) {
                             return 1;
                          }
                        break;
                        case ( $badword{0} == "*"):                                 // *badword
                          $badword = substr($badword, 1);
			  if ( preg_match("/$badword(\W|$)/i", $text) ) {
                             return 1;
                          }
                        break;
                        default:                                                    // badword
			  if ( preg_match("/(\W|^)$badword(\W|$)/i", $text) ) {
                             return 1;
                          }
                        }
 		}

		// Quit to return false if configured to
		// perform advanced filtering using regular expressions
 		if ($bw_perform_regexp == '0') {
			return 0;
 		}

		foreach ($bw_regexp_array as $badword_regexp) {
			if (preg_match(rtrim($badword_regexp), $text)) {
				return 1;
			}
		}

		return 0;
	}

	/**
	 * Run the badword flush on the provided text
	 * Return string
	 * Param1 string $text
	 * Param2 array $user
	 * Desc Removes the badwords from text and returns the string based on setup
	 */
	function flush($text, $user) {
		global $bw_regexp_array, $bw_admin_array, $bw_word_array;
		global $bw_perform_filter, $bw_allow_admin, $bw_perform_regexp;

		// Quit to return false if configured
		// not to perform filter
		if ($bw_perform_filter == '0' || strlen($text) == 0) {
			return $text;
		}

		// Check for allow badwords for admin users
		// as per the configuration
		if ($bw_allow_admin == '1' && Badword::isAdminUser($user) == 1) {
			return $text;
		}

		// Else perform basic badword check

		foreach ($bw_word_array as $badword) {
			
			// remove whitespace at beginning or end of badword
			$badword = trim($badword);

			// make the number of asterix' match the string length
			$replace = str_repeat('*', strlen($badword));
                        			
                        // adapt replacement string in case of wildcards
                        switch (TRUE) {
                        case ( $badword{0} == "*" && substr($badword, -1) == "*" ): // *badword*
                          $badword = substr($badword, 1, -1);
			  $replace= "\$1".substr($replace, 2)."\$2";
			  $text = preg_replace("/$badword/i",$replace,$text);
                        break;
                        case ( substr($badword, -1) == "*"):                        // badword*
                          $badword = substr($badword, 0, -1);
                          $replace = "\$1".substr($replace, 1);
			  $text = preg_replace("/(\W|^)$badword/i",$replace,$text);
                        break;
                        case ( $badword{0} == "*"):                                 // *badword
                         $badword = substr($badword, 1);
			  $replace= substr($replace, 1)."\$1";
			  $text = preg_replace("/$badword(\W|$)/i",$replace,$text);
                        break;
                        default:                                                    // badword
			  $replace="\$1".$replace."\$2";
			  $text = preg_replace("/(\W|^)$badword(\W|$)/i",$replace,$text);
                        }

		}

		// Quit to return false if configured to
		// perform advanced filtering using regular expressions
		if ($bw_perform_regexp == '0') {
			return $text;
		}

		foreach ($bw_regexp_array as $badword_regexp) {
			$text = preg_replace(rtrim($badword_regexp), '***', $text);
		}
		return $text;
	}


	/**
	 * Check if the message was shouted by admin
	 */
	function isAdminUser($user) {
		global $bw_admin_array;
		global $mosConfig_absolute_path;

		$bw_username = $user->username;

		foreach ($bw_admin_array as $admin) {
 			if (stristr($bw_username, rtrim($admin))) {
				return 1;
			}
		}
		return 0;
	}

}

?>
