<?php
/**
* AkoComment - A User Comments Component
* @version 2.0
* @package AkoComment
* @copyright (C) 2004 by Arthur Konze - All rights reserved!
* @license http://www.konze.de/content/view/8/26/ Copyrighted Commercial Software
**/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
require_once( $mosConfig_absolute_path."/administrator/components/com_akocomment/class.akocomment.php");
require_once( $mainframe->getPath( 'admin_html' ) );
# Get the right language if it exists
  if (file_exists($mosConfig_absolute_path.'/components/com_akocomment/languages/'.$mosConfig_lang.'.php')) {
    include($mosConfig_absolute_path.'/components/com_akocomment/languages/'.$mosConfig_lang.'.php');
  } else {
    include($mosConfig_absolute_path.'/components/com_akocomment/languages/english.php');
  }
switch ($task) {
  case "new":
    editComment( $option, 0 );
    break;

  case "edit":
    editComment( $option, $cid[0] );
    break;

  case "save":
    saveComment( $option );
    break;

  case "remove":
    removeComments( $cid, $option );
    break;

  case "publish":
    publishComments( $cid, 1, $option );
    break;

  case "unpublish":
    publishComments( $cid, 0, $option );
    break;

  ##############################################

  case "about":
    showAbout();
    break;

  ##############################################

  case "settings":
    showConfig( $option );
    break;

  case "savesettings":
    $ac_sectionlist   = implode(',',$_POST['acselections']);
    saveConfig ($option, $ac_autopublish, $ac_anonentry, $ac_sorting, $ac_bbcodesupport, $ac_picsupport, $ac_smiliesupport, $ac_notify, $ac_notify_email, $ac_openingmode, $ac_pagination, $ac_perpage, $ac_formposition, $ac_regedit, $ac_mainmode, $ac_sectionlist, $ac_badwords2);
    break;

  ##############################################

  case "language":
    showLanguage($option);
    break;

  case "savefile":
    saveLanguage($file, $filecontent, $option);
    break;

  ##############################################

  default:
    showComments( $option );
    break;
}
echo "<div><font class='small'><b>AkoComment V2.0</b> - &copy Copyright 2004 by Arthur Konze - <a href='http://www.mamboportal.com/' target='_blank'>www.mamboportal.com</a>. Polska adaptacja: <a href='http://www.joomlademo.pl/' target='_blank'>APW Zwiastun - JoomlaDemoPl</a></font></div>";

############################################################################

function showComments ( $option ) {
  global $database, $mainframe;

  $limit      = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );
  $limitstart = $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );
  $search     = $mainframe->getUserStateFromRequest( "search{$option}", 'search', '' );
  $search     = $database->getEscaped( trim( strtolower( $search ) ) );

  $where = array();
  if ($search) {
    $where[] = "LOWER(comment) LIKE '%$search%'";
  }

  $database->setQuery( "SELECT count(*) FROM #__akocomment AS a" . (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "") );
  $total = $database->loadResult();
  echo $database->getErrorMsg();
  include_once( "includes/pageNavigation.php" );
  $pageNav = new mosPageNav( $total, $limitstart, $limit  );

  $database->setQuery( "SELECT * FROM #__akocomment"
    . (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
    . "\nORDER BY id DESC"
    . "\nLIMIT $pageNav->limitstart,$pageNav->limit"
  );
  $rows = $database->loadObjectList();
  if ($database->getErrorNum()) {
    echo $database->stderr();
    return false;
  }

  HTML_comment::showComments( $option, $rows, $search, $pageNav );
}

############################################################################

function editComment( $option, $uid ) {
  global $database;

  $row = new mosAkocomment( $database );
  $row->load( $uid );

  #Get list of Content
  $contentitem[] = mosHTML::makeOption( '0', _A_AKOCOM_SEL_CONTENT_ITEM );
  $database->setQuery( "SELECT id AS value, title AS text FROM #__content ORDER BY title" );
  $contentitem = array_merge( $contentitem, $database->loadObjectList() );
  if (count( $contentitem ) < 1) {
    mosRedirect( "index2.php?option=com_sections&scope=content", _A_AKOCOM_MUST_ADD_CTN_FIRST );
  }
  $clist = mosHTML::selectList( $contentitem, 'contentid', 'class="inputbox" size="1"', 'value', 'text', intval( $row->contentid ) );

  # Check if new or edit
  if ($uid) {
    $row->checkout( $my->id );
  } else {
    $row->published = 0;
  }

  # Prepare Ordering box
  $order = mosGetOrderingList( "SELECT ordering AS value, title AS text FROM #__akocomment"
    . "\nWHERE contentid='$row->contentid' ORDER BY ordering" );
  $olist = mosHTML::selectList( $order, 'ordering', 'class="inputbox" size="1"', 'value', 'text', intval( $row->ordering ) );

  # Build up published box
  $publist = mosHTML::yesnoRadioList( 'published', 'class="inputbox"', $row->published );

  HTML_comment::editComment( $option, $row, $clist, $olist, $publist );
}

############################################################################

function saveComment( $option ) {
  global $database;
  $row = new mosAkocomment( $database );
  if (!$row->bind( $_POST )) {
    echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
    exit();
  }
  $row->date = date( "Y-m-d H:i:s" );
  $row->ip   = getenv('REMOTE_ADDR');
  if (!$row->store()) {
    echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
    exit();
  }
  $row->updateOrder( "contentid='$row->contentid'" );
  mosRedirect( "index2.php?option=$option" );
}

############################################################################

function publishComments( $cid=null, $publish=1,  $option ) {
  global $database;
  if (!is_array( $cid ) || count( $cid ) < 1) {
    $action = $publish ? 'publish' : 'unpublish';
    echo "<script> alert('" ._A_AKOCOM_SEL_ITEM_TO. "$action'); window.history.go(-1);</script>\n";
    exit;
  }
  $cids = implode( ',', $cid );
  $database->setQuery( "UPDATE #__akocomment SET published='$publish' WHERE id IN ($cids)" );
  if (!$database->query()) {
    echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
    exit();
  }
  mosRedirect( "index2.php?option=$option" );
}

############################################################################

function showAbout() {
  HTML_comment::showAbout();
}

############################################################################

function showConfig( $option ) {
  global $mosConfig_absolute_path, $database;
  require($mosConfig_absolute_path."/administrator/components/com_akocomment/config.akocomment.php");
?>
    <script language="javascript" type="text/javascript">
    function submitbutton(pressbutton) {
      var form = document.adminForm;
      if (pressbutton == 'cancel') {
        submitform( pressbutton );
        return;
      }
      if (form.ac_autopublish.value == ""){
        alert( "<?php echo _A_AKOCOM_CHOSE_PUBLISH_MODE ?>" );
      } else {
        submitform( pressbutton );
      }
    }
    </script>

  <form action="index2.php" method="POST" name="adminForm">
  <table cellpadding="4" cellspacing="0" border="0" width="100%">
  <tr>
    <td width="100%" class="sectionname">
      <img src="components/com_akocomment/images/logo.png">
    </td>
  </tr>
  </table>

  <?php
  $akogbtabs = new mosTabs( 0 );
  $akogbtabs->startPane( "ako_comment" );
  $akogbtabs->startTab(_A_AKOCOM_GENERAL,"General-page");
  ?>
  <table width="100%" border="0" cellpadding="4" cellspacing="2" class="adminForm">
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo _A_AKOCOM_OPERATING_MODE ?>:</strong></td>
      <td align="left" valign="top">
      <?php
        $acmainmode[] = mosHTML::makeOption( '0', _A_AKOCOM_INDIVIDUAL_BOT_COMM );
        $acmainmode[] = mosHTML::makeOption( '1', _A_AKOCOM_CHOOSE_FROM_SECT_BELOW );
        $mc_ac_mainmode = mosHTML::selectList( $acmainmode, 'ac_mainmode', 'class="inputbox" size="2"', 'value', 'text', $ac_mainmode );
        echo $mc_ac_mainmode;
      ?>
      </td>
      <td align="left" valign="top" width="50%"><?php echo _A_AKOCOM_OPERATING_MODE_TT ?></td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo _A_AKOCOM_SECTION_AVAILABLE ?>:</strong></td>
      <td align="left" valign="top"><select size="5" name="acselections[]" class="inputbox" multiple="multiple">
      <?php
        $seclistarray = explode (",", $ac_sectionlist);
        $database -> setQuery("SELECT id,title FROM #__sections ORDER BY title ASC");
        $dbsectionlist = $database -> loadObjectList();
        foreach ($dbsectionlist as $slrow){
          echo "<option value='$slrow->id' ";
          if (in_array ($slrow->id, $seclistarray)) echo _A_AKOCOM_SELECTED;
          echo ">$slrow->title</option>";
        }
      ?>
        </select>
      </td>
      <td align="left" valign="top"><?php echo _AKOCOMMENT_SECTION_AVAILABLE_TT ?></td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo _A_AKOCOM_AUTOPUBLISH ?></strong></td>
      <td align="left" valign="top">
      <?php
        echo mosHTML::yesnoRadioList( 'ac_autopublish', 'class="inputbox"', $ac_autopublish );
      ?>
      </td>
      <td align="left" valign="top"><?php echo _A_AKOCOM_AUTOMATICALLY_PUBLISH ?></td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo _A_AKOCOM_ANNONYMOUS_COMMENTS ?></strong></td>
      <td align="left" valign="top">
      <?php
        echo mosHTML::yesnoRadioList( 'ac_anonentry', 'class="inputbox"', $ac_anonentry );
      ?>
      </td>
      <td align="left" valign="top"><?php echo _A_AKOCOM_SEL_UNREGISTERED_COMMENTS ?></td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo _A_AKOCOM_COMMENT_WINDOW ?></strong></td>
      <td align="left" valign="top">
      <?php
        $acopeningmode[] = mosHTML::makeOption( '0', _A_AKOCOM_OPEN_IN_SAME_WINDOW );
        $acopeningmode[] = mosHTML::makeOption( '1', _A_AKOCOM_OPEN_IN_NEW_WINDOW );
        $mc_ac_openingmode = mosHTML::selectList( $acopeningmode, 'ac_openingmode', 'class="inputbox" size="2"', 'value', 'text', $ac_openingmode );
        echo $mc_ac_openingmode;
      ?>
      </td>
      <td align="left" valign="top"><?php echo _A_AKOCOM_MSG_CHOSECOMMENTS_TO_OPEN ?></td>
    </tr>
  </table>
  <?php
    $akogbtabs->endTab();
    $akogbtabs->startTab(_A_AKOCOM_LAYOUT,"Layout-page");
  ?>
  <table width="100%" border="0" cellpadding="4" cellspacing="2" class="adminForm">
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo _A_AKOCOM_COMMNTS_SORTING ?>:</strong></td>
      <td align="left" valign="top">
      <?php
        $acsorting[] = mosHTML::makeOption( 'DESC', _A_AKOCOM_NEW_FIRST );
        $acsorting[] = mosHTML::makeOption( 'ASC', _A_AKOCOM_NEW_LAST );
        $mc_ac_sorting = mosHTML::selectList( $acsorting, 'ac_sorting', 'class="inputbox" size="2"', 'value', 'text', $ac_sorting );
        echo $mc_ac_sorting;
      ?>
      </td>
      <td align="left" valign="top" width="50%"><strong><?php echo _A_AKOCOM_SORTING_NEW_COMMENTS ?></td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo _A_AKOCOM_FORM_POSITION ?>:</strong></td>
      <td align="left" valign="top">
      <?php
        $acformpos[] = mosHTML::makeOption( '0', _A_AKOCOM_BEHIND_COMMENTS );
        $acformpos[] = mosHTML::makeOption( '1', _A_AKOCOM_ABOVE_COMMENTS );
        $mc_ac_formposition = mosHTML::selectList( $acformpos, 'ac_formposition', 'class="inputbox" size="2"', 'value', 'text', $ac_formposition );
        echo $mc_ac_formposition;
      ?>
      </td>
      <td align="left" valign="top"><?php echo _A_AKOCOM_FORM_POSITION_TT ?></td>
    </tr>
  </table>
    <?php
    $akogbtabs->endTab();
    $akogbtabs->startTab(_A_AKOCOM_POSTING,"Posting-page");
    ?>
  <table width="100%" border="0" cellpadding="4" cellspacing="2" class="adminForm">
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo _A_AKOCOM_BB_CODE ?></strong></td>
      <td align="left" valign="top">
      <?php
        echo mosHTML::yesnoRadioList( 'ac_bbcodesupport', 'class="inputbox"', $ac_bbcodesupport );
      ?>
      </td>
      <td align="left" valign="top" width="50%"><?php echo _A_AKOCOM_BB_CODE_TT ?></td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo _A_AKOCOM_PICTURE_SUPPORT ?></strong></td>
      <td align="left" valign="top">
      <?php
        echo mosHTML::yesnoRadioList( 'ac_picsupport', 'class="inputbox"', $ac_picsupport );
      ?>
      </td>
      <td align="left" valign="top"><?php echo _A_AKOCOM_PICTURE_SUPPORT_TT ?></td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo _A_AKOCOM_SMILIE_SUPPORT?>:</strong></td>
      <td align="left" valign="top">
      <?php
        echo mosHTML::yesnoRadioList( 'ac_smiliesupport', 'class="inputbox"', $ac_smiliesupport );
      ?>
      </td>
      <td align="left" valign="top"><?php echo _A_AKOCOM_SMILIE_SUPPORT_TT?></td>
    </tr>
  </table>
  <?php
    $akogbtabs->endTab();
    $akogbtabs->startTab(_A_AKOCOM_NOTIFICATION,"Notification-page");
  ?>
  <table width="100%" border="0" cellpadding="4" cellspacing="2" class="adminForm">
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo _A_AKOCOM_NOTIFY_ADMIN ;?>:</strong></td>
      <td align="left" valign="top">
      <?php
        echo mosHTML::yesnoRadioList( 'ac_notify', 'class="inputbox"', $ac_notify );
      ?>
      </td>
      <td align="left" valign="top" width="50%"><?php echo _A_AKOCOM_NOTIFY_ADMIN_TT ;?></td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo _A_AKOCOM_ADMIN_EMAIL; ?></strong></td>
      <td align="left" valign="top"><input type="text" name="ac_notify_email" value="<?php echo "$ac_notify_email"; ?>"></td>
      <td align="left" valign="top"><?php echo _A_AKOCOM_ADMIN_EMAIL_TT ;?></td>
    </tr>
  </table>
  <?php
  $akogbtabs->endTab();
  $akogbtabs->startTab(_A_AKOCOM_INTEGRATION,"Integration-page");
  ?>
  <table width="100%" border="0" cellpadding="4" cellspacing="2" class="adminForm">
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo _BADWORD_ADMIN_USE_BADWORDS ;?>:</strong></td>
      <td align="left" valign="top">
      <?php
        echo mosHTML::yesnoRadioList( 'ac_badwords2', 'class="inputbox"', $ac_badwords2 );
      ?>
      </td>
      <td align="left" valign="top"><?php echo _BADWORD_ADMIN_USE_BADWORDS_TT ;?></td>
    </tr>
  </table>
  <?php
  $akogbtabs->endTab();
  $akogbtabs->endPane();
  ?>
  <input type="hidden" name="option" value="<?php echo $option; ?>">
  <input type="hidden" name="act" value="<?php echo $act; ?>">
  <input type="hidden" name="task" value="">
  <input type="hidden" name="boxchecked" value="0">
</form>
<?php
}

############################################################################

function saveConfig ($option, $ac_autopublish, $ac_anonentry, $ac_sorting, $ac_bbcodesupport, $ac_picsupport, $ac_smiliesupport, $ac_notify, $ac_notify_email, $ac_openingmode, $ac_pagination, $ac_perpage, $ac_formposition, $ac_regedit, $ac_mainmode, $ac_sectionlist, $ac_badwords2) {
  $configfile = "components/com_akocomment/config.akocomment.php";
  @chmod ($configfile, 0766);
  $permission = is_writable($configfile);
  if (!$permission) {
    $mosmsg = _A_AKOCOM_CONFIG_IS_NOT_WRITABLE;
    mosRedirect("index2.php?option=$option&act=config",$mosmsg);
    break;
  }

  $config  = "<?php\n";
  $config .= "\$ac_autopublish = \"$ac_autopublish\";\n";
  $config .= "\$ac_anonentry = \"$ac_anonentry\";\n";
  $config .= "\$ac_sorting = \"$ac_sorting\";\n";
  $config .= "\$ac_bbcodesupport = \"$ac_bbcodesupport\";\n";
  $config .= "\$ac_picsupport = \"$ac_picsupport\";\n";
  $config .= "\$ac_smiliesupport = \"$ac_smiliesupport\";\n";
  $config .= "\$ac_notify = \"$ac_notify\";\n";
  $config .= "\$ac_notify_email = \"$ac_notify_email\";\n";
  $config .= "\$ac_openingmode = \"$ac_openingmode\";\n";
  $config .= "\$ac_pagination = \"$ac_pagination\";\n";
  $config .= "\$ac_perpage = \"$ac_perpage\";\n";
  $config .= "\$ac_formposition = \"$ac_formposition\";\n";
  $config .= "\$ac_regedit = \"$ac_regedit\";\n";
  $config .= "\$ac_mainmode = \"$ac_mainmode\";\n";
  $config .= "\$ac_sectionlist = \"$ac_sectionlist\";\n";
  $config .= "\$ac_badwords2 = \"$ac_badwords2\";\n";  
  $config .= "?>";

  if ($fp = fopen("$configfile", "w")) {
    fputs($fp, $config, strlen($config));
    fclose ($fp);
  }
  mosRedirect("index2.php?option=$option&task=settings", _A_AKOCOM_SETTING_SAVED);
}


############################################################################

function removeComments( $cid, $option ) {
  global $database;
  if (count( $cid )) {
    $cids = implode( ',', $cid );
    $database->setQuery( "DELETE FROM #__akocomment WHERE id IN ($cids)" );
    if (!$database->query()) {
      echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
    }
  }
  mosRedirect( "index2.php?option=$option" );
}

############################################################################

function showLanguage($option) {

  global $mosConfig_absolute_path, $mosConfig_lang;

  if (file_exists($mosConfig_absolute_path.'/components/com_akocomment/languages/'.$mosConfig_lang.'.php')) {
    $file = $mosConfig_absolute_path.'/components/com_akocomment/languages/'.$mosConfig_lang.'.php';
  } else {
    $file = $mosConfig_absolute_path.'/components/com_akocomment/languages/english.php';
  }
  @chmod ($file, 0766);
  $permission = is_writable($file);
  if (!$permission) {
    echo "<center><h1><font color=red>"._A_AKOCOM_WARN."</FONT></h1><BR>";
    echo "<B>"._A_AKOCOM_WARN_CHMOD_TXT."</B></center><BR />";
  }

  HTML_comment::showFile($file,$option);
}

function saveLanguage($file, $filecontent, $option) {

  @chmod ($file, 0766);
  $permission = is_writable($file);
  if (!$permission) {
    mosRedirect("index2.php?option=$option&task=language", _A_AKOCOM_FILE_NOT_WRITABLE);
    break;
  }

  if ($fp = fopen( $file, "w")) {
    fputs($fp,stripslashes($filecontent));
    fclose($fp);
    mosRedirect( "index2.php?option=$option&task=language", _A_AKOCOM_LANGUAGE_FILE_SAVED );
  }
}