/*
The contents of this file including all code, commments, etc. within is
Copyright Jim Auldridge 2005.

DISCLAIMER: THIS CODE SUPPLIED 'AS IS', WITH NO WARRANTY EXPRESSED OR IMPLIED.
YOU USE AT YOUR OWN RISK.  JIM AULDRIDGE DOES NOT ACCEPT ANY LIABILITY FOR
ANY LOSS OR DAMAGE RESULTING FROM USE, WHETHER CAUSED BY CODING MISTAKES (MINE
OR YOURS), 'HACKERS' FINDING HOLES, OR ANY OTHER MEANS.
*/
var cookieLib = {
	/* METHOD: getCookie();
	 * PURPOSE: Get the value of a cookie
	 * ARGUMENTS: STRING - cookieName - The name of the cookie value you wish to retrieve
	 * RETURN: If cookie exists - STRING - the cookie value
	 *         If cookie does not exist - null
	 */
	getCookie: function(cookieName) {
		var cookieNameStart,valueStart,valueEnd,value;
		cookieNameStart = document.cookie.indexOf(cookieName+'=');
		if (cookieNameStart < 0) {return null;}
		valueStart = document.cookie.indexOf(cookieName+'=') + cookieName.length + 1;
		valueEnd = document.cookie.indexOf(";",valueStart);
		if (valueEnd == -1){valueEnd = document.cookie.length;}
		value = document.cookie.substring(valueStart,valueEnd );
		value = unescape(value);
		if (value == "") {return null;}
		return value;
	},
	/* METHOD: setCookie();
	 * PURPOSE: Write (or overwrite) a cookie (with supplemental information such as expiration, path, domain)
	 * ARGUMENTS: cookieName - STRING - The name of the cookie value you wish to write
	 *            value - STRING - The string you wish to write as the value of the cookie
	 *            hoursToLive - INT - The number of hours until the cookie will expire.  If you do not provide
	 *                                this argument, or provide anything that can evaluate to false, the cookie
	 *                                will never expire, thus remaining available until it is deleted.
	 *            path - STRING - (Optional) The path for which the cookie is valid.  Defaults to "/" if not
	 *                             passed, or passed empty.
	 *            domain - STRING - (Optional) The domain for which the cookie is valid.  Defaults to
	 *                              window.location.hostname if not passed, or passed empty.
	 *            secure - BOOL - (Optional) This is used to instruct the browser to use SSL when sending the
	 *                            cookie to a server.  It is almost never used, and will thus be assumed false
	 *                            unless you explicitly pass true.
	 * RETURN: VOID
	 */
	setCookie: function(cookieName,value,hoursToLive,path,domain,secure) {
		var expireString,timerObj,expireAt,pathString,domainString,secureString,setCookieString;
		//If no hoursToLive argument, or it is not numeric, do not set expiration
		if (!hoursToLive || parseInt(hoursToLive)=='NaN'){expireString = "";}
		else {
			timerObj = new Date();
			timerObj.setTime(timerObj.getTime()+(parseInt(hoursToLive)*60*60*1000));
			expireAt = timerObj.toGMTString();
			expireString = "; expire="+expireAt;
		}
		//If no path argument, or argument is empty string, set path to default of /
		pathString = "; path=";
		(!path || path=="") ? pathString += "/" : pathString += path;
		//If no domain argument, or argument is empty string, set domain to default of window.location.hostname
		domainString = "; domain=";
		(!domain || domain=="") ? domainString += window.location.hostname : domainString += domain;
		//If secure argument is the BOOL true, set SSL string accordingly.  Otherwise, do not set it.
		(secure === true) ? secureString = "; secure" : secureString = "";
		value = escape(value);
		setCookieString = cookieName+"="+value+expireString+pathString+domainString;
		//alert(setCookieString);
		document.cookie = setCookieString;
	},
	/* METHOD: delCookie();
	 * PURPOSE: Delete a cookie
	 * ARGUMENTS: STRING - cookieName - The name of the cookie value you wish to delete
	 *            path - STRING - (Optional) The path for which the cookie was set.  This is necessary if
	 *                            the cookie was set with a particular path--you need to delete it with the
	 *                            same.  Defaults to "/" if not passed, or passed empty.
	 *            domain - STRING - (Optional) The domain for which the cookie was set.  This is necessary if
	 *                            the cookie was set with a particular domain--you need to delete it with the
	 *                            same.  Defaults to window.location.hostname if not passed, or passed empty.
	 * RETURN: VOID
	 */
	delCookie: function(cookieName,path,domain){
		cookieLib.setCookie(cookieName,"",-8760);
	}
};

//USAGE cookieLib.getCookie(..)
