<?php
/*
* JOGADGETS - PLUGIN/MAMBOT
* put candy to your Joomla!
* 
* (c) 2006 Artur Heinze 
* 
* Version: 0.43a
*/

include_once('_jgfw_/jgconfig.php');

class clsJGFW {
  
  var $messages = array();
  var $modulemode = false;
  
  /* Constructor */
	function clsJGFW()
	{
    //setting global storage var
    if(!isset($GLOBALS['gv_jgfw'])){
      $GLOBALS['gv_jgfw'] = array();
    }
    
    $this->inc_js('prototype.js');
    $this->inc_js('jgfw_functions.js');
    $this->inc_css('jgfw_css.css');
	}
  //----------------------------------------------------------------------------
  
  /* Modulinit */
	function modulinit()
	{
    //setting global storage var
    if(!isset($GLOBALS['gv_jgfw'])){
      $GLOBALS['gv_jgfw'] = array();
    }
    
    $this->modulemode = true;
    
    $this->inc_js('prototype.js');
    $this->inc_js('jgfw_functions.js');
    $this->inc_css('jgfw_css.css');
	}
  //----------------------------------------------------------------------------
  
  
  
  /* Include JS on demand in header */
	function inc_js($jsname,$folder='core')
	{
		if(!isset($GLOBALS['gv_jgfw']['inc_js'])){
      $GLOBALS['gv_jgfw']['inc_js'] = array();
    }
    
    if(!in_array($folder.'|'.$jsname, $GLOBALS['gv_jgfw']['inc_js'])){
      $GLOBALS['gv_jgfw']['inc_js'][]=$folder.'|'.$jsname;
      
      switch ($folder) {
        case 'core':
            $html = '<script type="text/javascript" src="'.$GLOBALS['mosConfig_live_site'].'/_jgfw_/js/'.$jsname.'"></script>';
            break;
        default:
            $html = '<script type="text/javascript" src="'.$folder.'/'.$jsname.'"></script>';
            break;
      }
      if($this->modulemode==false){
        $GLOBALS['mainframe']->addCustomHeadTag($html);
      }else{
        echo $html;
      }
    }
	}
	//----------------------------------------------------------------------------
	
  /* Include CSS on demand in header */
	function inc_css($cssname,$folder='core')
	{
		if(!isset($GLOBALS['gv_jgfw']['inc_css'])){
      $GLOBALS['gv_jgfw']['inc_css'] = array();
    }
    
    if(!in_array($folder.'|'.$cssname, $GLOBALS['gv_jgfw']['inc_css'])){
      $GLOBALS['gv_jgfw']['inc_css'][]=$folder.'|'.$cssname;
      
      switch ($folder) {
        case 'core':
            $html = '<link rel="stylesheet" type="text/css" href="'.$GLOBALS['mosConfig_live_site'].'/_jgfw_/css/'.$cssname.'" media="all" />';
            break;
        default:
            $html = '<link rel="stylesheet" type="text/css" href="'.$folder.'/'.$cssname.'" media="all" />';
            break;
      }
      if($this->modulemode==false){
        $GLOBALS['mainframe']->addCustomHeadTag($html);
      }else{
        echo $html;
      }
      
    }
	}
	//----------------------------------------------------------------------------
	function addmsg($text){
    $this->messages[] = $text;
  }
  //----------------------------------------------------------------------------
  function flushmsg($style='info'){
    if(count($this->messages)){
      $this->showinfo(implode('<br />', $this->messages),$style);
      $this->messages = array();
    }
  }
	//----------------------------------------------------------------------------
	function showinfo($text,$style='info'){
    echo '<div class="jgmsgbox"><div class="'.$style.'">'.$text.'</div></div>';
  }
  function message($text,$style='info'){
    return '<div class="jgmsgbox"><div class="'.$style.'">'.$text.'</div></div>';
  }
  //----------------------------------------------------------------------------
	
	/* Get parameter-list */
	function getprm($str){
    $bArr = array();
    preg_match_all('/[a-zA-Z0-9]+\:=\[(.*?)\]/', $str, $arr);
    
    if(!count($arr)) return false;
    
    foreach($arr[0] as $attr){
      $pieces = explode(':=', $attr);
      $bArr[trim($pieces[0])] = substr(trim($pieces[1]),1,-1);
    }

    return $bArr;
  }
  
  /* Make recursive dir-path */
  function mkdirs($dir, $mode = 0777, $recursive = true){
    if( is_null($dir) || $dir === '' ){
      return FALSE;
    }
    if( is_dir($dir) || $dir === '/' ){
      return TRUE;
    }
    if( $this->mkdirs(dirname($dir), $mode, $recursive) ){
      return mkdir($dir, $mode);
    }
    return FALSE;
  }
  
  //Direct Callers
  //----------------------------------------------------------------------------
  
  #Tooltip
  function tooltip($text,$prmlist = array()){
    $this->inc_js('overlib.js');
    if(isset($prmlist['set'])) $prmlist['set'] = ','.$prmlist['set'];
    $output = '<span style="'.@$prmlist['style'].'" onMouseover="return overlib(\''.$prmlist['text'].'\''.@$prmlist['set'].')" onmouseout="return nd();">'.$text.'</span>';

    return $output;
  }
  //----------------------------------------------------------------------------
  
  #Quote
  function quote($text,$prmlist = array()){
    if(!isset($prmlist['class'])) $prmlist['class'] = 'jgquote';
    $output = '<div style="'.@$prmlist['style'].'"  class="'.$prmlist['class'].'">'.$text.'</div>';

    return $output;
  }
  //----------------------------------------------------------------------------

  #Imagetext
  function imagetext($text,$prmlist = array()){
    $getlist = '';
    
    if(!isset($prmlist['text'])) $prmlist['text']='No text was defined!'; 
    if(isset($prmlist['size'])) $getlist.='&size='.$prmlist['size'];
		if(isset($prmlist['color'])) $getlist.='&color='.$prmlist['color'];
		if(isset($prmlist['bgcolor'])) $getlist.='&bgcolor='.$prmlist['bgcolor'];
		if(isset($prmlist['font'])) $getlist.='&font='.$prmlist['font'];

		$output = '<img src="_jgfw_/image.php?text='.urlencode(strip_tags($text)).$getlist.'" alt="'.$text.'" />';

		return $output;
  }
  //----------------------------------------------------------------------------
  
  #Lightboxgallery
  function lightboxgallery($prmlist = array()){
    $this->inc_js('efx/scriptaculous.js');
	  $this->inc_js('lightbox.js');
    $this->inc_css('lightbox.css');
    
    if(!isset($prmlist['title'])) $prmlist['title']=' ';
    if(isset($prmlist['filter'])){
      $prmlist['filter']='&'.$prmlist['filter'];
      $prmlist['filter'] = str_replace(array('fltr',';'), array('fltr[]','&'), $prmlist['filter']);
    }
		
		if(!isset($prmlist['cols'])) $prmlist['cols'] = $GLOBALS['confJG']['xgal_defcols'];
		$output = $this->_showImgDir($prmlist['folder'], -1, 100, 100, $prmlist['cols'],$prmlist['title'],@$prmlist['filter']);
   
    return $output;
  }
  //----------------------------------------------------------------------------

  #Lightboximage
  function lightboximage($prmlist = array()){
    $this->inc_js('efx/scriptaculous.js');
    $this->inc_js('lightbox.js');
    $this->inc_css('lightbox.css');
      
    $localpath = $GLOBALS['mosConfig_absolute_path'].'/';
    if(preg_match('/^(http|https):/i',$prmlist['src'])) $localpath='';
    
    if(!isset($prmlist['title'])) $prmlist['title']=' ';
    if(isset($prmlist['filter'])){
      $prmlist['filter']='&'.$prmlist['filter'];
      $prmlist['filter'] = str_replace(array('fltr',';'), array('fltr[]','&'), $prmlist['filter']);
    }
    
    $output= '<a href="'.$prmlist['src'].'" rel="lightbox" class="effectable" style="'.@$prmlist['style'].'" title="'.@$prmlist['title'].' ">
              <img src="_jgfw_/cls/phpthumb/phpThumb.php?src='.$localpath.$prmlist['src'].'&w='.$prmlist['width'].'&h='.@$prmlist['height'].@$prmlist['filter'].'" border="0" alt="'.@$prmlist['alt'].'" />
              </a>';
    return $output;
  }
  //----------------------------------------------------------------------------

  #FLV-Video
  function _flvideo($prmlist = array()){
    
    $localpath = $GLOBALS['mosConfig_live_site']. '/';
    if(preg_match('/^(http:)/i',$prmlist['file'])) $localpath='';
    
    $prmlist['file'] = $localpath.$prmlist['file'];
		$output = '<embed src="_jgfw_/files/flvplayer.swf?file={file}{auto}" wmode="transparent" width="{width}" height="{height}" 
                      type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" />';
      
      if(@$prmlist['width']=='') $prmlist['width']=320;
      if(@$prmlist['height']=='') $prmlist['height']=240;
      if(@$prmlist['autostart']!='') $prmlist['autostart'] = '&autoStart=false';
      
    $output = str_replace(array('{file}','{width}','{height}','{auto}'), array($prmlist['file'],$prmlist['width'],$prmlist['height'],$prmlist['autostart']), $output);

    return $output;
  }
  //----------------------------------------------------------------------------
  
  #Play MP3
  function _mp3($prmlist = array()){
    
      $localpath = $GLOBALS['mosConfig_live_site']. '/';
      if(preg_match('/^(http:)/i',$prmlist['file'])) $localpath='';
      
      $prmlist['file'] = $localpath.$prmlist['file'];
        
      if(!isset($prmlist['height'])) $prmlist['height'] = 120;
      if(!isset($prmlist['width'])) $prmlist['width'] = 300;
      
      //if just single mp3-file
		  if(substr(strtolower($prmlist['file']), -3) == 'mp3'){
          $prmlist['height']=20;
      }
      
      $output = '<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" width="{width}" height="{height}"
            		 codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0">
                 <param name="movie" jgfw_/files/mp3player.swf?file={file}&config=cfgmp3player.xml" />
                 <param name="wmode" value="transparent" />
                 <embed src="_jgfw_/files/mp3player.swf?file={file}&config=cfgmp3player.xml" wmode="transparent" width="{width}" height="{height}" name="mp3player" 
            	          type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" /></object>';
    
      $output = str_replace(array('{file}','{height}','{width}'), 
                            array($prmlist['file'],$prmlist['height'],$prmlist['width']), 
                            $output);

      return $output;
  }
  //----------------------------------------------------------------------------

  #Media files
  function media($prmlist = array()){
    
    $localpath = $GLOBALS['mosConfig_live_site']. '/';
    if(preg_match('/^(http|rtsp|mms)/i',$prmlist['file'])) $localpath='';
    
    $prmlist['file'] = $localpath.$prmlist['file'];
    $mediatype = explode('.', strtolower(basename($prmlist['file'])));
    
    if($mediatype[1]!='mp3' && $mediatype[1]!='flv'){
      if(@$prmlist['width']=='') $prmlist['width']=320;
      if(@$prmlist['height']=='') $prmlist['height']=240;
      if(@$prmlist['autostart']!='') $prmlist['autostart'] = 'false';
    }
    
    switch ($mediatype[1]) {
      //mediaplayer
      case 'wmv':
      case 'avi':
      case 'mpg':
      case 'mpeg':
      case 'wma':
        $output = '<embed src="{file}" width="{width}" height="{height}" border="0" autoStart="{auto}" type="application/x-mplayer2" /></embed>';
        $output = str_replace(array('{file}','{width}','{height}','{auto}'), array($prmlist['file'],$prmlist['width'],$prmlist['height'],$prmlist['autostart']), $output);
        break;
      //quicktime
      case 'mov':
        $output = '<embed pluginspage="http://www.apple.com/quicktime/download/" type="video/quicktime" src="{file}" width="{width}" height="{height}" controller="true" autoplay="{auto}" />';
        $output = str_replace(array('{file}','{width}','{height}','{auto}'), array($prmlist['file'],$prmlist['width'],$prmlist['height'],$prmlist['autostart']), $output);
        break;
      //flashmovie
      case 'swf':
        $output = '<embed src="{file}" wmode="transparent" width="{width}" height="{height}" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" />';
        $output = str_replace(array('{file}','{width}','{height}'), array($prmlist['file'],$prmlist['width'],$prmlist['height']), $output);
        break;
      //flashvideo
      case 'flv':
        $output = $this->_flvideo($prmlist);
        break;
      //mp3audio
      case 'mp3':
        $output = $this->_mp3($prmlist);
        break;	
      default:
      	 return $this->message('Mediatype is not supported');
      	break;
    }

    return $output;
  }
  //----------------------------------------------------------------------------


  /* PARSER-BOT */
  function doparse($text) {

    //tooltip
    //--------------------------------------------------------------------------
  	$regex = "#{jgtip(\s*.*?)}(.*?){/jgtip}#s";	
  	preg_match_all( $regex, $text, $matches );
  	
  	if(count($matches[1])>0){
      
      for($i=0;$i<count($matches[1]);$i++){
        $prmlist = $this->getprm($matches[1][$i]);
        $output = $this->tooltip($matches[2][$i],$prmlist);
        
        $text = preg_replace($regex, $output, $text, 1);
      }
    }
    
    //quotes
    //--------------------------------------------------------------------------
  	$regex = "#{jgquote(\s*.*?)}(.*?){/jgquote}#s";	
  	preg_match_all( $regex, $text, $matches );
  	
  	if(count($matches[1])>0){
      
      for($i=0;$i<count($matches[1]);$i++){
        $prmlist = $this->getprm($matches[1][$i]);
        $output = $this->quote($matches[2][$i],$prmlist);
        
        $text = preg_replace($regex, $output, $text, 1);
      }
    }    
    
    //imagetext
    //--------------------------------------------------------------------------
    $regex = '/{jgitext(\s*.*?)}/i';
  	preg_match_all( $regex, $text, $matches );
    
    if(count($matches[0])){
      foreach ($matches[0] as $needle) {
    		$prmlist = $this->getprm($needle);  				
    		$output = $this->imagetext($prmlist['text'],$prmlist);
        
        $text = preg_replace($regex, $output, $text, 1);
    	}
    }    
    
    //tabber
    //--------------------------------------------------------------------------
  	$regex = "#{jgtabber(\s*.*?)}(.*?){/jgtabber}#s";	
  	preg_match_all( $regex, $text, $matches );
  	
  	if(count($matches[1])>0){
      
      $this->inc_js('tabber.js');
      $this->inc_css('tabber.css');
      
      for($i=0;$i<count($matches[1]);$i++){
        $prmlist = $this->getprm($matches[1][$i]);

        $output = '<div class="tabber">';
        //$output.= str_replace(array('[tab ==','==]','[/tab]'), array('<div class="tabbertab'.@$prmlist['class'].'" title="','">','</div>'), $matches[2][$i]);
        
        //
        preg_match_all('/\[tab ==(.*?)==\](.*?)\[\/tab\]/is', $matches[2][$i], $m);
        for($z=0;$z<count($m[0]);$z++){
          $output.= '<div class="tabbertab" title="'.$m[1][$z].'">'.$m[2][$z].'</div>';
        }
        //
        $output.= '</div>';
        $text = preg_replace($regex, $output, $text, 1);
      }
    }
    
  	//infobox
  	//--------------------------------------------------------------------------
  	$regex = "#{jgibox(\s*.*?)}(.*?){/jgibox}#s";	
  	preg_match_all( $regex, $text, $matches );
    
    if(count($matches[1])>0){
      
      $this->inc_js('efx/scriptaculous.js');
      if(!isset($GLOBALS['cInfobox'])) $GLOBALS['cInfobox']=0;
      
      for($i=0;$i<count($matches[1]);$i++){
        $prmlist = $this->getprm($matches[1][$i]);
        $divid = 'fgcbox'.$GLOBALS['cInfobox'].'_'.$i.time();
        
        $output= '
                 <div class="jg_ibox'.@$prmlist['class'].'" style="'.$prmlist['style'].'">
                  <div class="jg_iboxcaption'.@$prmlist['class'].'" onclick="Effect.toggle(\''.$divid.'\',\'slide\'); return false;">'.$prmlist['title'].'</div>
                  <div id="'.$divid.'" style="display:none"><div class="jg_iboxcontent'.@$prmlist['class'].'">'.$matches[2][$i].'</div></div>
                 </div>
                 ';
        $text = preg_replace($regex, $output, $text, 1);
        $GLOBALS['cInfobox'] = $GLOBALS['cInfobox'] + 1;
      }
    }
    
    //lightboxgallery
  	//--------------------------------------------------------------------------
  	
  	$regex = '/{jgxgal(\s*.*?)}/i';
    preg_match_all( $regex, $text, $matches);
  	
  	if(count($matches[0])){
      
    	foreach ($matches[0] as $needle) {
    		$prmlist = $this->getprm($needle);  		
    		$output = $this->lightboxgallery($prmlist);
    		
        $text = preg_replace($regex, $output, $text, 1);
    	}
  	}  	
    
    //lightboxsingleimage
  	//------------------------------------------------------------------
  	$regex = '/{jgxtimg\s*.*?}/i';	
  	preg_match_all( $regex, $text, $matches );
  	
  	if(count($matches[0])>0){

      foreach($matches[0] as $needle){
        $prmlist = $this->getprm($needle);
        $output = $this->lightboximage($prmlist);
        
        $text = preg_replace($regex, $output, $text, 1);
      }
    }
    
    //flvideo (outdated!)
  	//-----------------------------------------------------------------
  	$regex = '/{jgflv\s*.*?}/i';	
  	preg_match_all( $regex, $text, $matches );
    
    if(count($matches[0])>0){
      
      foreach($matches[0] as $needle){
        $prmlist = $this->getprm($needle);
        $output = $this->_flvideo($prmlist);
        
        $text = preg_replace($regex, $output, $text, 1);
      }
    } 
    
    //mp3  (outdated!)
  	//-----------------------------------------------------------------
  	$regex = '/{jgmp3\s*.*?}/i';	
  	preg_match_all( $regex, $text, $matches );
    
    if(count($matches[0])>0){
      
      foreach($matches[0] as $needle){
        $prmlist = $this->getprm($needle);
        $output = $this->_mp3($prmlist);
  
        $text = preg_replace($regex, $output, $text, 1);
      }
    }
    
    //media files
  	//-----------------------------------------------------------------
  	$regex = '/{jgmedia\s*.*?}/i';	
  	preg_match_all( $regex, $text, $matches );
    
    if(count($matches[0])>0){
      
      foreach($matches[0] as $needle){
        $prmlist = $this->getprm($needle);
        $output = $this->media($prmlist);
        
        $text = preg_replace($regex, $output, $text, 1);
      }
    }
    
    //content box
  	//--------------------------------------------------------------------------
  	
  	$regex = '#{jgbox(\s*.*?)}(.*?){/jgbox}#s';
    preg_match_all( $regex, $text, $matches);
  	
  	if(count($matches[1])>0){
  	  
  	  $this->inc_js('efx/scriptaculous.js');
  	  $this->inc_js('litbox.js');
      $this->inc_css('litbox.css');
      
    	for($i=0;$i<count($matches[1]);$i++){
    		$prmlist = $this->getprm($matches[1][$i]);  		
    		$output = '';
    		
    		if(@$prmlist['linktext']=='') $prmlist['linktext']=$GLOBALS['confJG']['contentbox_defltext'];
        if(@$prmlist['width']=='') $prmlist['width']=$GLOBALS['confJG']['contentbox_defwidth'];
        if(@$prmlist['height']=='') $prmlist['height']=$GLOBALS['confJG']['contentbox_defheight'];
        
        $sid = @$GET['id'].'_'.$i.time();
            
    		$output = '
          <a href="javascript:void(0)" onClick="new LITBox(\'\', {type:\'cbox'.$sid.'\', overlay:true, height:{height}, width:{width}});">'.$prmlist['linktext'].'</a>
          <div id="cbox'.$sid.'" style="display:none;">'.$matches[2][$i].'</div>';

    		  $output = str_replace(array('{width}','{height}'), array($prmlist['width'],$prmlist['height']), $output);
          $text = preg_replace($regex, $output, $text, 1);
    
    	}
  	}
  	
  	//accordion
    //--------------------------------------------------------------------------
  	$regex = "#{jgaccordion(\s*.*?)}(.*?){/jgaccordion}#s";	
  	preg_match_all( $regex, $text, $matches );
  	
  	if(count($matches[1])>0){
      
      $this->inc_js('efx/scriptaculous.js');
      $this->inc_css('accordion.css');
      
      for($i=0;$i<count($matches[1]);$i++){
        $prmlist = $this->getprm($matches[1][$i]);
        
        $output = '<div class="jgacccontainer'.@$prmlist['class'].'" style="'.@$prmlist['style'].'">';
        
        preg_match_all('/\[acctab ==(.*?)==\](.*?)\[\/acctab\]/is', $matches[2][$i], $m);
        for($z=0;$z<count($m[0]);$z++){
          if(!isset($GLOBALS['cAccordion'])) $GLOBALS['cAccordion']=0;
          $accid = 'acc_'.$GLOBALS['cAccordion'].'_'.$z;
          
          $output.= '<div class="jgacctabs" onClick="jgaccordion(\''.$accid.'\');">'.$m[1][$z].'</div>';
          $output.= '<div id="'.$accid.'" class="jgacccontent" style="display:none;"><div>'.$m[2][$z].'</div></div>';
          
          $GLOBALS['cAccordion'] = $GLOBALS['cAccordion']+1;
        }
        
        $output.= '</div>';
        $text = preg_replace($regex, $output, $text, 1);
      }
    }
    
    //include files
  	//-----------------------------------------------------------------
  	$regex = '/{jgfile\s*.*?}/i';	
  	preg_match_all( $regex, $text, $matches );
    
    if(count($matches[0])>0){
      
      foreach($matches[0] as $needle){
        $prmlist = $this->getprm($needle);
        if(@$prmlist['file']=='') continue;
        
        $incfile = $GLOBALS['mosConfig_absolute_path'].'/'.$prmlist['file'];
        if(file_exists($incfile)){
  				ob_start();
    				include($incfile);
    				$output .= ob_get_contents();
  				ob_end_clean();
  			}else{
  				$output = $this->message('Error: Loading '.$incfile.' file!'); 	
  			}        
        $text = preg_replace($regex, $output, $text, 1);
      }
    }
    
  	return $text;
  }
  //----------------------------------------------------------------------------
  
  
  //HELPER-FUNCTIONS
  //----------------------------------------------------------------------------
  //----------------------------------------------------------------------------
  
  function _showImgDir($dir, $i, $lar, $lon, $lin,$galtitle,$xfilter=''){

    		$output = '';$i++;
    			
    			$listFile = $this->_get_imagesinfolder($dir);
    			
    			// show files
    			if(count(@$listFile) > 0){
    				$output .= '<table cellspacing="1" cellpadding="0" border="0"><tr>';
    				
    				sort($listFile);
    				$x = 0 ;
    				$pcount = 1;
    				for($k = 0; $k < count($listFile); $k++){
    					$spacer = '';
    					
    					for($l = 0; $l < $i; $l++){ $spacer .= "&emsp;"; }
    					if($x % $lin == 0){ $output .= '</tr><tr>'; }
    
    					$img = $listFile[$k];
    					$tmp = explode('.', $img) ;
    					$x++ ;
    					
    					//display only that type of images
    					$tmp[1]=strtolower($tmp[1]);
    					if($tmp[1]=='jpg' OR $tmp[1]=='bmp' OR $tmp[1]=='gif' OR $tmp[1]=='png' OR $tmp[1]=='tif'){
    					
    						$output .= '<td>';
    						$output .= '<table class="thbbox" cellspacing="0" cellpadding="0" border="0" width="'.($lon+10).'" height="'.($lar+27).'">';
    						
    						if($GLOBALS['confJG']['xgal_numbering']==true){
                  $output .= '<tr><td class="jgxgaltd" valign="middle"><small><b>'.($pcount).'.</b></small></td></tr>';
    						}
                $output .= '<tr><td class="jgxgalimgtd">';
    					
    						$srcimg = $dir . '/' . $spacer . $img ;
    						list($width, $height, $type, $attr) = getimagesize($srcimg);
    					
    						$output .= '<a href="'.$srcimg.'" rel="lightbox['.md5($dir).']" class="effectable" title="'.$galtitle.'">';
    						$output .= '<img src="_jgfw_/cls/phpthumb/phpThumb.php?src='.$GLOBALS['mosConfig_absolute_path'].'/'.$srcimg.'&'.$GLOBALS['confJG']['xgal_filter'].$xfilter.'" alt="'.$img.'" title="'.$img.'" border="0"></a></td>';
    						$output .= '</tr></table>';
    						$output .= '</td>';
    						
    						$pcount = $pcount+1;
    					}
    					else 
    						$x-- ;
    				}
    				$output .= '</tr></table>';
    				
    				//tell how many image found in the folder
    				//$output .= "<br><small>" . $k . " Images displayed<b></b></small>";
    			}
    			
    		return $output;
  	}
  	//--------------------------------------------------------------------------
  	
  	function _get_imagesinfolder($fol){
      $files = array();
      
      if($checkDir = opendir($fol)){
    			$cFile = 0;
    			// check all files in $dir, add to array listFile
    			while($file = readdir($checkDir))
    			{
    				if($file != "." && $file != "..")
    				{
    					if(!is_dir($fol.'/'.$file))
    					{
    						$files[$cFile] = $file;
    						$cFile++;
    					}
    				}
    			}
      }
      @closedir($checkDir);
      return $files;
    }
}
// END clsJGFW;


//Init "Framework"-Class
if(!isset($GLOBALS['jgw'])){
  $GLOBALS['jgw'] = new clsJGFW();
}

?>
