<?php
/**
* @version $Id: jacronym.php,v  1.0.2 2006/06/16 13:18:05 jaco Exp $
* @package Joomla
* @license Joomla http://www.gnu.org/copyleft/gpl.html GNU/GPL
* Joomla is Free Open Source Software
* @package Joomla Accessibility Tools v.1.0
* @subpackage Jacronym
* @author Ute Jacobi www.uascom.de
* @copyright (c) 2005 Ute Jacobi
* @license Creative Commons License <a href="http://creativecommons.org/licenses/by-nc-sa/2.5/legalcode">
* <a href="http://creativecommons.org/licenses/by-nc-sa/2.5/deed.de">Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Germany License</a>
*/

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

/**
** Usage: nothing
*
*/

$_MAMBOTS->registerFunction( 'onPrepareContent', 'botJacronym' );

function botJacronym( $published, &$row, &$params, $page=0 ) {
	global $mosConfig_absolute_path;

	if ( !$published ) {
		return;
	}

	$chk_jglossar = strpos ( $row->text, "Joomla Accessibility Tools"); //NOT REMOVE!
	
	if ( $chk_jglossar ){
		return;
	} else {
		$row->text = botJacronym_repl( $row->text );
		return true;		
	}
}

function botJacronym_repl ( &$matches ) {
	global $mosConfig_live_site,$mosConfig_absolute_path, $mosConfig_locale, $database;
	
	$userlang 	= substr( $mosConfig_locale, 0, 2 );
	$query 		= "SELECT id FROM #__mambots WHERE element = 'jacronym' AND folder = 'content'";
	$database->setQuery( $query );
	$id 		= $database->loadResult();
	$mambot 	= new mosMambot( $database );
	$mambot->load( $id );
	$params 	=& new mosParameters( $mambot->params );
	$plg		= $mosConfig_absolute_path."/mambots/content/jat/jacronym.inc";
	$jdata		= $mosConfig_absolute_path.Jacronym_path($params->def( 'jdata', '/files/jacronym.inc' ) );
	$chkpath	= !file_exists( $jdata ) ? false : true ;
	$jdata		= !( $chkpath ) ? $plg : $jdata ;
	$sep		= "#";
		
	$wordlist = file( $jdata );
	$c =  count( $wordlist );	

	for ( $i=0; $i<=$c; $i++ ) {
		$temp = explode($sep,$wordlist[$i] );
		
		if (!trim($temp[0] )==""){
			if ( !trim( $temp[2] )=="" ){
				if ( trim( strtolower( $temp[2] ) ) == strtolower( $userlang ) ){
					$lang	= "";
				} else {
					$lang	= " lang=\"".$temp[2]."\"";
				}
			}
			
			$newstr="<acronym title=\"".$temp[1]."\"".$lang.">".$temp[0]."</acronym>";
			$matches =str_replace( "'", "%x0035x20AC%", $matches );   
		
			$s= htmlentities( $temp[0] );
		 	$s = str_replace( "'", "%x0035x20AC%", $s );  
			$s=Jacronym_mask( $s );
 			$pat = "/(((<[^>]*)";
  			$pat .= "|({[^}]*)";
			$pat .= "|(title=\" |alt=\"[^\"]*)";
 	   		$pat .= "|(>[^<\/acronym]*)";
	  		$pat .= "|(>[^<\/abbr]*)";
			$pat .= "|(<script[^<\/script]*)";
			$pat .= "|([\w\.\-]+@\w+[\w\.\-]*?[^\.\w{1,4}]*)";	  	
			$pat .= ")|".$s."\b)/e";
			$matches =preg_replace( $pat, '"\2"=="\1"? "\0":"$newstr"', $matches );
		}
	}
	$matches = str_replace( "%x0035x20AC%", "'", $matches );  
	return  $matches;
}

function Jacronym_path( $path ){
 	if( substr( $path,0,1 )=="/" ){
 		return $path;
 	} else {
 		return "/".$path;
 	}	
}

function Jacronym_mask($string)
{
  return str_replace ( array ( '.' , '+', '*', '?', '^', '$', '|', '(', ')', '[', ']', '{', '}'), array ( '\.' , '\+', '\*', '\?', '\^', '\$', '\|', '\(', '\)', '\[', '\]', '\{', '\}' ), $string );
}
?>
