<?php
/**
* @version $Id: mod_fullmenu.php 4801 2006-08-28 16:10:28Z stingrey $
* @package Joomla
* @copyright Copyright (C) 2005 Open Source Matters. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// no direct access
defined( '_VALID_MOS' ) or die( 'Restricted access' );

if (!defined( '_JOS_FULLMENU_MODULE' )) {
	/** ensure that functions are declared only once */
	define( '_JOS_FULLMENU_MODULE', 1 );

	/**
	* Full DHTML Admnistrator Menus
	* @package Joomla
	*/
	class mosFullAdminMenu {
		/**
		* Show the menu
		* @param string The current user type
		*/
		function show( $usertype='' ) {
		global $acl, $database, $adminLanguage;
		global $mosConfig_live_site, $mosConfig_enable_stats, $mosConfig_caching;

		// cache some acl checks
		$canConfig 			= $acl->acl_check( 'administration', 'config', 'users', $usertype );

		$manageTemplates 	= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_templates' );
		$manageTrash 		= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_trash' );
		$manageMenuMan 		= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_menumanager' );
		$manageLanguages 	= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_languages' );
		$installModules 	= $acl->acl_check( 'administration', 'install', 'users', $usertype, 'modules', 'all' );
		$editAllModules 	= $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'modules', 'all' );
		$installMambots 	= $acl->acl_check( 'administration', 'install', 'users', $usertype, 'mambots', 'all' );
		$editAllMambots 	= $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'mambots', 'all' );
		$installComponents 	= $acl->acl_check( 'administration', 'install', 'users', $usertype, 'components', 'all' );
		$editAllComponents 	= $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'components', 'all' );
		$canMassMail 		= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_massmail' );
		$canManageUsers 	= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_users' );

		$query = "SELECT a.id, a.title, a.name"
		. "\n FROM #__sections AS a"
		. "\n WHERE a.scope = 'content'"
		. "\n GROUP BY a.id"
		. "\n ORDER BY a.ordering"
		;
		$database->setQuery( $query );
		$sections = $database->loadObjectList();
		
		$menuTypes = mosAdminMenus::menutypes();
		?>
		<div id="myMenuID"></div>
		<script language="JavaScript" type="text/javascript">
		var myMenu =
		[
		<?php
	// Home Sub-Menu
?>			[null,'<?php echo $adminLanguage->A_MENU_HOME;?>','index2.php',null,'<?php echo $adminLanguage->A_MENU_CTRL_PANEL;?>'],
			_cmSplit,
			<?php
	// Site Sub-Menu
?>			[null,'<?php echo $adminLanguage->A_MENU_SITE;?>',null,null,'<?php echo $adminLanguage->A_MENU_SITE_MANAGEMENT;?>',
<?php
			if ($canConfig) {
?>				['<img src="../includes/js/ThemeOffice/config.png" />','<?php echo $adminLanguage->A_MENU_GLOBAL_CONF;?>','index2.php?option=com_config&hidemainmenu=1',null,'Configuration'],
<?php
			}
			if ($manageLanguages) {
?>				['<img src="../includes/js/ThemeOffice/language.png" />','<?php echo $adminLanguage->A_MENU_LANGUAGES;?>',null,null,'<?php echo $adminLanguage->A_MENU_MANAGE_LANG;?>',
  					['<img src="../includes/js/ThemeOffice/language.png" />','<?php echo $adminLanguage->A_MENU_LANG_MANAGE;?>','index2.php?option=com_languages',null,'<?php echo $adminLanguage->A_MENU_MANAGE_LANG;?>'],
   				],
<?php
			}
?>				['<img src="../includes/js/ThemeOffice/media.png" />','<?php echo $adminLanguage->A_MENU_MEDIA_MANAGE;?>','index2.php?option=com_media',null,'<?php echo $adminLanguage->A_MENU_MANAGE_MEDIA;?>'],
					['<img src="../includes/js/ThemeOffice/preview.png" />', '<?php echo $adminLanguage->A_MENU_PREVIEW;?>', null, null, '<?php echo $adminLanguage->A_MENU_PREVIEW;?>',
					['<img src="../includes/js/ThemeOffice/preview.png" />','<?php echo $adminLanguage->A_MENU_NEW_WINDOW;?>','<?php echo $mosConfig_live_site; ?>/index.php','_blank','<?php echo $mosConfig_live_site; ?>'],
					['<img src="../includes/js/ThemeOffice/preview.png" />','<?php echo $adminLanguage->A_MENU_INLINE;?>','index2.php?option=com_admin&task=preview',null,'<?php echo $mosConfig_live_site; ?>'],
					['<img src="../includes/js/ThemeOffice/preview.png" />','<?php echo $adminLanguage->A_MENU_INLINE_POS;?>','index2.php?option=com_admin&task=preview2',null,'<?php echo $mosConfig_live_site; ?>'],
				],
				['<img src="../includes/js/ThemeOffice/globe1.png" />', '<?php echo $adminLanguage->A_MENU_STATISTICS;?>', null, null, '<?php echo $adminLanguage->A_MENU_STATISTICS_SITE;?>',
<?php
			if ($mosConfig_enable_stats == 1) {
?>					['<img src="../includes/js/ThemeOffice/globe4.png" />', '<?php echo $adminLanguage->A_MENU_BROWSER;?>', 'index2.php?option=com_statistics', null, '<?php echo $adminLanguage->A_MENU_BROWSER;?>'],
<?php
			}
?>					['<img src="../includes/js/ThemeOffice/search_text.png" />', '<?php echo $adminLanguage->A_MENU_SEARCH_TEXT;?>', 'index2.php?option=com_statistics&task=searches', null, '<?php echo $adminLanguage->A_MENU_SEARCH_TEXT;?>']
				],
<?php
			if ($manageTemplates) {
?>				['<img src="../includes/js/ThemeOffice/template.png" />','<?php echo $adminLanguage->A_MENU_TEMP_MANAGE;?>',null,null,'<?php echo $adminLanguage->A_MENU_TEMP_CHANGE;?>',
  					['<img src="../includes/js/ThemeOffice/template.png" />','<?php echo $adminLanguage->A_MENU_SITE_TEMP;?>','index2.php?option=com_templates',null,'<?php echo $adminLanguage->A_MENU_TEMP_CHANGE;?>'],
  					_cmSplit,
  					['<img src="../includes/js/ThemeOffice/template.png" />','<?php echo $adminLanguage->A_MENU_ADMIN_TEMP;?>','index2.php?option=com_templates&client=admin',null,'<?php echo $adminLanguage->A_MENU_ADMIN_CHANGE_TEMP;?>'],
  					_cmSplit,
  					['<img src="../includes/js/ThemeOffice/template.png" />','<?php echo $adminLanguage->A_MENU_MODUL_POS;?>','index2.php?option=com_templates&task=positions',null,'<?php echo $adminLanguage->A_MENU_TEMP_POS;?>']
  				],
<?php
			}
			if ($manageTrash) {
?>				['<img src="../includes/js/ThemeOffice/trash.png" />','<?php echo $adminLanguage->A_MENU_TRASH_MANAGE;?>','index2.php?option=com_trash',null,'<?php echo $adminLanguage->A_MENU_MANAGE_TRASH;?>'],
<?php
			}
			if ($canManageUsers || $canMassMail) {
?>				['<img src="../includes/js/ThemeOffice/users.png" />','<?php echo $adminLanguage->A_MENU_USER_MANAGE;?>','index2.php?option=com_users&task=view',null,'<?php echo $adminLanguage->A_MENU_MANAGE_USER;?>'],
<?php
				}
?>			],
<?php
	// Menu Sub-Menu
?>			_cmSplit,
			[null,'<?php echo $adminLanguage->A_MENU_MENU;?>',null,null,'<?php echo $adminLanguage->A_MENU_MANAGEMENT;?>',
<?php
			if ($manageMenuMan) {
?>				['<img src="../includes/js/ThemeOffice/menus.png" />','<?php echo $adminLanguage->A_MENU_MANAGER;?>','index2.php?option=com_menumanager',null,'<?php echo $adminLanguage->A_MENU_MANAGER;?>'],
				_cmSplit,
<?php
			}
			foreach ( $menuTypes as $menuType ) {
?>				['<img src="../includes/js/ThemeOffice/menus.png" />','<?php echo $menuType;?>','index2.php?option=com_menus&menutype=<?php echo $menuType;?>',null,''],
<?php
			}
?>			],
			_cmSplit,
<?php
	// Content Sub-Menu
?>			[null,'<?php echo $adminLanguage->A_MENU_CONTENT;?>',null,null,'<?php echo $adminLanguage->A_MENU_CONTENT_MANAGE;?>',
<?php
			if (count($sections) > 0) {
?>				['<img src="../includes/js/ThemeOffice/edit.png" />','<?php echo $adminLanguage->A_MENU_CONTENT_BY_SECTION;?>',null,null,'<?php echo $adminLanguage->A_MENU_CONTENT_MANAGERS;?>',
<?php
				foreach ($sections as $section) {
					$txt = addslashes( $section->title ? $section->title : $section->name );
?>					['<img src="../includes/js/ThemeOffice/document.png" />','<?php echo $txt;?>', null, null,'<?php echo $txt;?>',
						['<img src="../includes/js/ThemeOffice/edit.png" />', '<?php echo $adminLanguage->A_MENU_ITEMS_INVERSE;?> <?php echo $txt;?> <?php echo $adminLanguage->A_MENU_ITEMS;?>', 'index2.php?option=com_content&sectionid=<?php echo $section->id;?>',null,null],
						['<img src="../includes/js/ThemeOffice/backup.png" />', '<?php echo $txt;?> <?php echo $adminLanguage->A_COMP_CONTENT_ARCHIVE;?>','index2.php?option=com_content&task=showarchive&sectionid=<?php echo $section->id;?>',null,null],
						['<img src="../includes/js/ThemeOffice/add_section.png" />', '<?php echo $adminLanguage->A_MENU_CATEGORIES_INVERSE;?> <?php echo $txt;?> <?php echo $adminLanguage->A_MENU_CATEGORIES;?>', 'index2.php?option=com_categories&section=<?php echo $section->id;?>',null, null],
					],
<?php
				} // foreach
?>				],
				_cmSplit,
<?php
			}
?>
				['<img src="../includes/js/ThemeOffice/edit.png" />','<?php echo $adminLanguage->A_ALL_MANAGER;?>','index2.php?option=com_content&sectionid=0',null,'<?php echo $adminLanguage->A_MENU_MANAGE_CONTENT;?>'],
  				['<img src="../includes/js/ThemeOffice/edit.png" />','<?php echo $adminLanguage->A_STATIC_MANAGER;?>','index2.php?option=com_typedcontent',null,'<?php echo $adminLanguage->A_MENU_ITEMS_CONTENT_STATIC;?>'],
  				_cmSplit,
  				['<img src="../includes/js/ThemeOffice/add_section.png" />','<?php echo $adminLanguage->A_COMP_SECT_MANAGER;?>','index2.php?option=com_sections&scope=content',null,'<?php echo $adminLanguage->A_MENU_CONTENT_SEC;?>'],
				['<img src="../includes/js/ThemeOffice/add_section.png" />','<?php echo $adminLanguage->A_CATEGORY_MANAGER;?>','index2.php?option=com_categories&section=content',null,'<?php echo $adminLanguage->A_MENU_CONTENT_CAT;?>'],
				_cmSplit,
  				['<img src="../includes/js/ThemeOffice/home.png" />','<?php echo $adminLanguage->A_FRONTPAGE_MANAGER;?>','index2.php?option=com_frontpage',null,'<?php echo $adminLanguage->A_MENU_ITEMS_FRONT;?>'],
  				['<img src="../includes/js/ThemeOffice/edit.png" />','<?php echo $adminLanguage->A_MENU_ARCHIVE_MANAGE;?>','index2.php?option=com_content&task=showarchive&sectionid=0',null,'<?php echo $adminLanguage->A_MENU_ITEMS_ARCHIVE;?>'],
  				['<img src="../includes/js/ThemeOffice/globe3.png" />', '<?php echo $adminLanguage->A_MENU_PAGE_IMP;?>', 'index2.php?option=com_statistics&task=pageimp', null, '<?php echo $adminLanguage->A_MENU_PAGE_IMP;?>'],
			],
<?php
	// Components Sub-Menu
	if ($installComponents) {
?>			_cmSplit,
			[null,'<?php echo $adminLanguage->A_MENU_COMPONENTS;?>',null,null,'<?php echo $adminLanguage->A_MENU_COMPONENTS_MANAGEMENT;?>',
<?php
		$query = "SELECT *"
		. "\n FROM #__components"
		. "\n WHERE name != 'frontpage'"
		. "\n AND name != 'media manager'"
		. "\n ORDER BY ordering, name"
		;
		$database->setQuery( $query );
		$comps = $database->loadObjectList();	// component list
		$subs = array();	// sub menus
		// first pass to collect sub-menu items
		foreach ($comps as $row) {
			if ($row->parent) {
				if (!array_key_exists( $row->parent, $subs )) {
					$subs[$row->parent] = array();
					}
					$subs[$row->parent][] = $row;
				}
			}
			$topLevelLimit = 19; //You can get 19 top levels on a 800x600 Resolution
			$topLevelCount = 0;
			foreach ($comps as $row) {
				if ($editAllComponents | $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'components', $row->option )) {
					if ($row->parent == 0 && (trim( $row->admin_menu_link ) || array_key_exists( $row->id, $subs ))) {
						$topLevelCount++;
						if ($topLevelCount > $topLevelLimit) {
							continue;
						}
						$name = addslashes( $row->name );
						$alt = addslashes( $row->admin_menu_alt );
						$link = $row->admin_menu_link ? "'index2.php?$row->admin_menu_link'" : "null";
						echo "\t\t\t\t['<img src=\"../includes/$row->admin_menu_img\" />','$name',$link,null,'$alt'";
						if (array_key_exists( $row->id, $subs )) {
							foreach ($subs[$row->id] as $sub) {
								echo ",\n";
								$name = addslashes( $sub->name );
								$alt = addslashes( $sub->admin_menu_alt );
								$link = $sub->admin_menu_link ? "'index2.php?$sub->admin_menu_link'" : "null";
								echo "\t\t\t\t\t['<img src=\"../includes/$sub->admin_menu_img\" />','$name',$link,null,'$alt']";
							}
						}
						echo "\n\t\t\t\t],\n";
					}
				}
			}
			if ($topLevelLimit < $topLevelCount) {
			echo "\t\t\t\t['<img src=\"../includes/js/ThemeOffice/sections.png\" />','". $adminLanguage->A_MENU_MORE_COMP2 ."','index2.php?option=com_admin&task=listcomponents',null,'". $adminLanguage->A_MENU_MORE_COMP ."'],\n";
		}
?>
			],
<?php
	// Modules Sub-Menu
		if ($installModules | $editAllModules) {
?>			_cmSplit,
			[null,'<?php echo $adminLanguage->A_MENU_MODULES;?>',null,null,'<?php echo $adminLanguage->A_MENU_MODULES_MANAGEMENT;?>',
<?php
			if ($editAllModules) {
?>				['<img src="../includes/js/ThemeOffice/module.png" />', '<?php echo $adminLanguage->A_MENU_SITE_MOD;?>', "index2.php?option=com_modules", null, '<?php echo $adminLanguage->A_MENU_SITE_MOD_MANAGE;?>'],
				['<img src="../includes/js/ThemeOffice/module.png" />', '<?php echo $adminLanguage->A_MENU_ADMIN_MOD;?>', "index2.php?option=com_modules&client=admin", null, '<?php echo $adminLanguage->A_MENU_ADMIN_MOD_MANAGE;?>'],
<?php
			}
?>			],
<?php
		} // if ($installModules | $editAllModules)
	} // if $installComponents
	// Mambots Sub-Menu
	if ($installMambots | $editAllMambots) {
?>			_cmSplit,
			[null,'<?php echo $adminLanguage->A_MENU_MAMBOTS;?>',null,null,'<?php echo $adminLanguage->A_MENU_MAMBOTS_MANAGE;?>',
<?php
		if ($editAllMambots) {
?>				['<img src="../includes/js/ThemeOffice/module.png" />', '<?php echo $adminLanguage->A_MENU_SITE_MAMBOTS;?>', "index2.php?option=com_mambots", null, '<?php echo $adminLanguage->A_MENU_MAMBOT_MANAGE;?>'],
<?php
		}
?>			],
<?php
	}
?>
<?php
	// Installer Sub-Menu
	if ($installModules) {
?>			_cmSplit,
			[null,'<?php echo $adminLanguage->A_MENU_INSTALLERS;?>',null,null,'<?php echo $adminLanguage->A_MENU_INSTALLERS_LIST;?>',
<?php
		if ($manageTemplates) {
?>				['<img src="../includes/js/ThemeOffice/install.png" />','<?php echo $adminLanguage->A_MENU_TEMPLATES_SITE;?>','index2.php?option=com_installer&element=template&client=',null,'<?php echo $adminLanguage->A_MENU_TEMPLATES_SITE_INST;?>'],
				['<img src="../includes/js/ThemeOffice/install.png" />','<?php echo $adminLanguage->A_MENU_TEMPLATES_ADMIN;?>','index2.php?option=com_installer&element=template&client=admin',null,'<?php echo $adminLanguage->A_MENU_TEMPLATES_ADMIN_INST;?>'],
<?php
		}
		if ($manageLanguages) {
?>				['<img src="../includes/js/ThemeOffice/install.png" />','<?php echo $adminLanguage->A_MENU_LANGUAGES;?>','index2.php?option=com_installer&element=language',null,'<?php echo $adminLanguage->A_MENU_INSTALL_LANG;?>'],
				_cmSplit,
<?php
		}
?>				['<img src="../includes/js/ThemeOffice/install.png" />', '<?php echo $adminLanguage->A_MENU_COMPONENTS;?>','index2.php?option=com_installer&element=component',null,'<?php echo $adminLanguage->A_MENU_INST_UNST_COMPONENTS;?>'],
				['<img src="../includes/js/ThemeOffice/install.png" />', '<?php echo $adminLanguage->A_MENU_MODULES;?>', 'index2.php?option=com_installer&element=module', null, '<?php echo $adminLanguage->A_MENU_INST_UNST_MODULES;?>'],
				['<img src="../includes/js/ThemeOffice/install.png" />', '<?php echo $adminLanguage->A_MENU_MAMBOTS;?>', 'index2.php?option=com_installer&element=mambot', null, '<?php echo $adminLanguage->A_MENU_INST_UNST_MAMBOTS;?>'],
			],
<?php
	} // if ($installModules)
	// Messages Sub-Menu
	if ($canConfig) {
?>			_cmSplit,
  			[null,'<?php echo $adminLanguage->A_MENU_MESSAGES;?>',null,null,'<?php echo $adminLanguage->A_MENU_MESSAGES_MANAGEMENT;?>',
  				['<img src="../includes/js/ThemeOffice/messaging_inbox.png" />','<?php echo $adminLanguage->A_MENU_INBOX;?>','index2.php?option=com_messages',null,'<?php echo $adminLanguage->A_MENU_PRIV_MSG;?>'],
  				['<img src="../includes/js/ThemeOffice/messaging_config.png" />','<?php echo $adminLanguage->A_MENU_MESSAGES_CONF;?>','index2.php?option=com_messages&task=config&hidemainmenu=1',null,'<?php echo $adminLanguage->A_MENU_MESSAGES_CONF;?>']
  			],
<?php
	// System Sub-Menu
?>			_cmSplit,
  			[null,'<?php echo $adminLanguage->A_MENU_SYSTEM; ?>',null,null,'<?php echo $adminLanguage->A_MENU_SYSTEM_MNG; ?>',
  			   ['<img src="../includes/js/ThemeOffice/sysinfo.png" />', '<?php echo $adminLanguage->A_MENU_SYSTEM_INFO;?>', 'index2.php?option=com_admin&task=sysinfo', null,'<?php echo $adminLanguage->A_COMP_ADMIN_SYSTEM;?>'],

<?php
  		if ($canConfig) {
?>				['<img src="../includes/js/ThemeOffice/checkin.png" />', '<?php echo $adminLanguage->A_MENU_GLOBAL_CHECK;?>', 'index2.php?option=com_checkin', null,'<?php echo $adminLanguage->A_MENU_CHECK_INOUT;?>'],
<?php
			if ($mosConfig_caching) {
?>				['<img src="../includes/js/ThemeOffice/config.png" />','<?php echo $adminLanguage->A_MENU_CLEAN_CACHE;?>','index2.php?option=com_admin&task=clean_cache',null,'<?php echo $adminLanguage->A_MENU_CLEAN_CACHE_ITEMS;?>'],
				['<img src="../includes/js/ThemeOffice/config.png" />','<?php echo $adminLanguage->A_MENU_CLEAN_CACHE_ALL;?>','index2.php?option=com_admin&task=clean_all_cache',null,'<?php echo $adminLanguage->A_MENU_CLEAN_CACHE_ALL;?>'],
<?php
			}
		}
?>			],
<?php
			}
?>			_cmSplit,
<?php
	// Help Sub-Menu
?>			[null,'<?php echo $adminLanguage->A_HELP; ?>','index2.php?option=com_admin&task=help',null,null]
		];
		cmDraw ('myMenuID', myMenu, 'hbr', cmThemeOffice, 'ThemeOffice');
		</script>
<?php
	}


	/**
	* Show an disbaled version of the menu, used in edit pages
	* @param string The current user type
	*/
	function showDisabled( $usertype='' ) {
		global $acl, $adminLanguage;

		$canConfig 			= $acl->acl_check( 'administration', 'config', 'users', $usertype );
		$installModules 	= $acl->acl_check( 'administration', 'install', 'users', $usertype, 'modules', 'all' );
		$editAllModules 	= $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'modules', 'all' );
		$installMambots 	= $acl->acl_check( 'administration', 'install', 'users', $usertype, 'mambots', 'all' );
		$editAllMambots 	= $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'mambots', 'all' );
		$installComponents 	= $acl->acl_check( 'administration', 'install', 'users', $usertype, 'components', 'all' );
		$editAllComponents 	= $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'components', 'all' );
		$canMassMail 		= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_massmail' );
		$canManageUsers 	= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_users' );

		$text = $adminLanguage->A_MENU_INACTIVE_FO_THIS_PAGE;
		?>
		<div id="myMenuID" class="inactive"></div>
		<script language="JavaScript" type="text/javascript">
		var myMenu =
		[
		<?php
	/* Home Sub-Menu */
		?>
			[null,'<?php echo $adminLanguage->A_MENU_HOME; ?>',null,null,'<?php echo $text; ?>'],
			_cmSplit,
		<?php
	/* Site Sub-Menu */
		?>
			[null,'<?php echo $adminLanguage->A_MENU_SITE; ?>',null,null,'<?php echo $text; ?>'
			],
		<?php
	/* Menu Sub-Menu */
		?>
			_cmSplit,
			[null,'<?php echo $adminLanguage->A_COMP_MENU; ?>',null,null,'<?php echo $text; ?>'
			],
			_cmSplit,
		<?php
	/* Content Sub-Menu */
		?>
 			[null,'<?php echo $adminLanguage->A_MENU_CONTENT; ?>',null,null,'<?php echo $text; ?>'
			],
		<?php
	/* Components Sub-Menu */
			if ( $installComponents) {
				?>
				_cmSplit,
				[null,'<?php echo $adminLanguage->A_MENU_COMPONENTS; ?>',null,null,'<?php echo $text; ?>'
				],
				<?php
			} // if $installComponents
			?>
		<?php
	/* Modules Sub-Menu */
			if ( $installModules | $editAllModules) {
				?>
				_cmSplit,
				[null,'<?php echo $adminLanguage->A_MENU_MODULES; ?>',null,null,'<?php echo $text; ?>'
				],
				<?php
			} // if ( $installModules | $editAllModules)
				?>
			<?php
		/* Mambots Sub-Menu */
				if ( $installMambots | $editAllMambots) {
					?>
					_cmSplit,
					[null,'<?php echo $adminLanguage->A_MENU_MAMBOTS; ?>',null,null,'<?php echo $text; ?>'
					],
					<?php
				} // if ( $installMambots | $editAllMambots)
				?>
	
	
				<?php
		/* Installer Sub-Menu */
				if ( $installModules) {
					?>
					_cmSplit,
					[null,'<?php echo $adminLanguage->A_MENU_INSTALLERS; ?>',null,null,'<?php echo $text; ?>'
						<?php
						?>
					],
					<?php
				} // if ( $installModules)
				?>
				<?php
		/* Messages Sub-Menu */
				if ( $canConfig) {
					?>
					_cmSplit,
		  			[null,'<?php echo $adminLanguage->A_MENU_MESSAGES; ?>',null,null,'<?php echo $text; ?>'
		  			],
					<?php
				}
				?>
	
				<?php
		/* System Sub-Menu */
				if ( $canConfig) {
					?>
					_cmSplit,
		  			[null,'<?php echo $adminLanguage->A_MENU_SYSTEM;; ?>',null,null,'<?php echo $text; ?>'
					],
					<?php
				}
				?>
				_cmSplit,
				<?php
		/* Help Sub-Menu */
				?>
				[null,'<?php echo $adminLanguage->A_HELP; ?>',null,null,'<?php echo $text; ?>']
			];
			cmDraw ('myMenuID', myMenu, 'hbr', cmThemeOffice, 'ThemeOffice');
			</script>
			<?php
		}
	}
}
$cache =& mosCache::getCache( 'mos_fullmenu' );

$hide = intval( mosGetParam( $_REQUEST, 'hidemainmenu', 0 ) );

if ( $hide ) {
	mosFullAdminMenu::showDisabled( $my->usertype );
} else {
	mosFullAdminMenu::show( $my->usertype );
}
?>