<?php
/**
* $Id: admin.badwords2.php,v 1.6 2005/09/05 15:09:42 walb Exp $
*
* Badwords2 Text Filtering Component!
* @ Copyright (C) 2005 - 2006 Wim Albers, Niels Vandekeybus, Robert Anthony Pitera
* @ Based on the initial work Badword by Pravin Hegde
* @ All rights reserved
* @ Badwords2 Text Filter component is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
global $mosConfig_absolute_path, $mosConfig_lang;
# Get the right language if it exists
if (file_exists($mosConfig_absolute_path.'/administrator/components/com_badwords2/language/'.$mosConfig_lang.'.php')) {
   require_once($mosConfig_absolute_path.'/administrator/components/com_badwords2/language/'.$mosConfig_lang.'.php');
} else {
   require_once($mosConfig_absolute_path.'/administrator/components/com_badwords2/language/english.php');
}

require_once( $mainframe->getPath( 'admin_html' ) );
require_once('settings.badwords2.php');
require_once('settings.badwords2.perm.php');
require_once('class.badwords2.settings.php');

$cid = mosGetParam( $_REQUEST, 'cid', array(0) );
$word = mosGetParam( $_REQUEST, 'word');
$id = mosGetParam( $_REQUEST, 'id');

if (!is_array( $cid )) {
	$cid = array(0);
}

switch ($task) {

	case "settings":
		editSettings( $option );
		break;

	case "saveSettings":
		saveSettings( $option );
		break;

	case "about":
		showAbout( $option );
		break;

	case "edit_admin":
	case "edit_regexp":
	case "edit_badword":
		editBwRow( $option, $cid[0] , $task);
		break;

	case "new_admin":
	case "new_regexp":
	case "new_badword":
		editBwRow( $option, -1 , $task);
		break;

	case "save_admin":
	case "save_regexp":
	case "save_badword":
		saveBwRow( $option , $word, $id, $task);
		break;

	case "cancel_admin":
	case "cancel_regexp":
	case "cancel_badword":
		cancelEdit( $option, $task );
		break;

	case "delete_admin":
	case "delete_regexp":
	case "delete_badword":
		removeBwData( $cid, $option, $task);
		break;

	case "badwords":
	case "admins":
	case "regexps":
	default:
		showBwData( $option , $task);
		break;
}

function editBwRow( $option, $id , $task) {
	global $bw_file_badwords, $bw_file_admins, $bw_file_regexps;

	if ($task == 'edit_regexp'  || $task == 'new_regexp') {
		$badword_file = $bw_file_regexps;
	} else if ($task == 'edit_admin' || $task == 'new_admin') {
		$badword_file = $bw_file_admins;
	} else {
		$badword_file = $bw_file_badwords;
	}

	$badword_data = file($badword_file);
	if ($id >= 0) {
		$row = $badword_data[$id];
	}

	HTML_badword::editBwRow( $row, $option, $id, $task );
}

function saveBwRow( $option, $word, $id, $task)
{

	global $bw_file_badwords, $bw_file_admins, $bw_file_regexps;

	if ($task == 'save_regexp') {
		$badword_file = $bw_file_regexps;
		$target_task = "regexps";
		$msg = _BW2_ADMIN_REGEX_HAS_BEEN;
		$word = stripslashes($word);
	} else if ($task == 'save_admin') {
		$badword_file = $bw_file_admins;
		$target_task = "admins";
		$msg = _BW2_ADMIN_USER_HAS_BEEN;
	} else {
		$badword_file = $bw_file_badwords;
		$target_task = "badwords";
		$msg = _BW2_ADMIN_BW_HAS_BEEN;
	}

	$badword_data = file($badword_file);
	$count = count($badword_data);
	if ($id >= 0 && $id <= $count) {
		$badword_data[$id] = $word."\n";
		$msg .= _BW2_ADMIN_CHANGED;
	} else {
		array_push($badword_data, $word."\n");
		$msg .= _BW2_ADMIN_ADDED;
	}

	$wordArray = implode( '', $badword_data);

	if ($fp = fopen($badword_file, "w")) {
		fputs($fp, $wordArray, strlen($wordArray));
		fclose ($fp);
		mosRedirect( "index2.php?option=$option&task=".$target_task, $msg );
	} else {
		mosRedirect( "index2.php?option=$option&task=".$target_task, _BW2_ADMIN_ERROR_CONF_WRITE );
	}
}


function cancelEdit( $option , $task) {

	if ($task == 'cancel_regexp') {
		$calc_task = "regexps";
	} else if ($task == 'cancel_admin') {
		$calc_task = "admins";
	} else {
		$calc_task = "badwords";
	}

	mosRedirect( "index2.php?option=$option&task=".$calc_task );
}

function showBwData( $option, $task ) {

	global $bw_file_badwords, $bw_file_admins, $bw_file_regexps;

	if ($task == 'regexps') {
		$badword_file = $bw_file_regexps;
	} else if ($task == 'admins') {
		$badword_file = $bw_file_admins;
	} else {
		$badword_file = $bw_file_badwords;
	}

	$badword_data = file($badword_file);

	HTML_badword::showBadwordData( $badword_data, $task);
}

function removeBwData( $cid, $option , $task) {
	global $bw_file_badwords, $bw_file_admins, $bw_file_regexps;

	if ($task == 'delete_regexp') {
		$badword_file = $bw_file_regexps;
		$remove_task = "regexps";
		$msg = _BW2_ADMIN_REGEX_REMOVED;
	} else if ($task == 'delete_admin') {
		$badword_file = $bw_file_admins;
		$remove_task = "admins";
		$msg = _BW2_ADMIN_USER_REMOVED;
	} else {
		$badword_file = $bw_file_badwords;
		$remove_task = "badwords";
		$msg = _BW2_ADMIN_BW_REMOVED;
	}

	if (count( $cid )) {

		$badword_data = file($badword_file);

		$i = 0;
		foreach($cid as $id) {
			unset($badword_data[$id]);
		}

		$wordArray = implode( '', $badword_data);

		if ($fp = fopen($badword_file, "w")) {
			fputs($fp, $wordArray, strlen($wordArray));
			fclose ($fp);
			mosRedirect( "index2.php?option=$option&task=".$remove_task, $msg );
		} else {
			mosRedirect( "index2.php?option=$option&task=".$remove_task, _BW2_ADMIN_ERROR_CONF_WRITE );
		}

	}
}

function showAbout( $option ) {

	$readme_lines = file ('components/com_badwords2/README.txt');

	HTML_badword::showAbout( $option , $readme_lines);
}

function editSettings( $option ) {

	$row = new bwSettings();
	$row->bindGlobals();

  $configfile = "components/com_badwords2/settings.badwords2.php";
  @chmod ($configfile, 0766);
  $permission = is_writable($configfile);
  if (!$permission) {
     echo _BW2_ADMIN_WARNING_CONF_WRITE;
  }

	# Badword filter on list
  $filterList = array();
  $filterList[] = mosHTML::makeOption( '1', _BW2_ADMIN_YES );
  $filterList[] = mosHTML::makeOption( '0', _BW2_ADMIN_NO );
  $lists['perform_filter'] = mosHTML::selectList( $filterList, 'perform_filter', 'class="inputbox" size="2"', 'value', 'text', $row->perform_filter );

  	# Badword regexp on list
  $regexpFilterList = array();
  $regexpFilterList[] = mosHTML::makeOption( '1', _BW2_ADMIN_YES );
  $regexpFilterList[] = mosHTML::makeOption( '0', _BW2_ADMIN_NO );
  $lists['perform_regexp'] = mosHTML::selectList( $regexpFilterList, 'perform_regexp', 'class="inputbox" size="2"', 'value', 'text', $row->perform_regexp);

 	# Badword Allow Admin list
  $allowAdminList = array();
  $allowAdminList[] = mosHTML::makeOption( '1', _BW2_ADMIN_YES );
  $allowAdminList[] = mosHTML::makeOption( '0', _BW2_ADMIN_NO );
  $lists['allow_admin'] = mosHTML::selectList( $allowAdminList, 'allow_admin', 'class="inputbox" size="2"', 'value', 'text', $row->allow_admin);

  HTML_badword::showSettings( $row, $lists, $option );
}

function saveSettings( $option ) {
	$row = new bwSettings();
	if (!$row->bind( $_POST )) {
		mosRedirect( "index2.php", $row->getError() );
	}

	$config = "<?php\n";
	$config .= $row->getVarText();
	$config .= "?>";

	if ($fp = fopen("components/com_badwords2/settings.badwords2.php", "w")) {
		fputs($fp, $config, strlen($config));
		fclose ($fp);
		mosRedirect( "index2.php?option=$option&task=settings", _BW2_ADMIN_CONF_UPDATED );
	} else {
		mosRedirect( "index2.php?option=$option&task=settings", _BW2_ADMIN_ERROR_CONF_WRITE );
	}
}

?>
